package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ReviewAnnexDao;
import com.ejianc.business.quality.entity.ReviewAnnexEntity;
import com.ejianc.business.quality.model.vo.ReviewAnnexVo;
import com.ejianc.business.quality.service.ReviewAnnexServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:00
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewAnnexServerImpl implements ReviewAnnexServer {
    private final ReviewAnnexDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewAnnexVo saveOrUpdate(ReviewAnnexVo saveOrUpdateVO) {
        ReviewAnnexEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewAnnexEntity.class);
        if (entity.getId() == null) {
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            entity.setCreateUserName(dao.getById(entity.getId()).getCreateUserName());
        }
        dao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReviewAnnexVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewAnnexVo detail(Long id) {
        ReviewAnnexEntity reviewAnnexEntity = dao.selectById(id);
        return BeanMapper.map(reviewAnnexEntity, ReviewAnnexVo.class);
    }

    @Override
    public IPage<ReviewAnnexVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("fileName", "fileYear"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewAnnexEntity> page = dao.queryPage(param, false);
        IPage<ReviewAnnexVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewAnnexVo.class));

        return pageData;

    }
}
