package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
* @Author: LCL
* @Date: 2024/6/25 上午9:43
* @Description: 经验反馈详情
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ExpFeedbackIssuedDetailVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 创建者姓名
     */
    private String updateUserName;

    /**
     * 经验反馈下达id
     */
    private Long issuedId;

    /**
     * 下达时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 归属类型
     */
    private String attributionType;

    /**
     * 专业
     */
    private String specialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 附件名称
     */
    private String annexName;

    /**
     * 上传部门id
     */
    private String uploadDepartmentId;

    /**
     * 上传部门name
     */
    private String uploadDepartmentName;

    /**
     * 上传时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 上报状态（已上报 未上报）
     */
    private String state;

    /**
     * 学习情况(全部学习 部分学习 未学习)
     */
    private String learnState;

    /**
     * 状态
     */
    private Integer billStatus;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
