package com.ejianc.business.quality.dao.impl.bpm;

import com.ejianc.business.quality.dao.ReviewIssuedDao;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;


/**
* @Author: LCL
* @Date: 2024/6/25 下午1:48
*/
@Service("reviewIssuedDetail")
@Slf4j
public class ReviewIssuedDetailBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private  ReviewIssuedDao issuedDao;
    @Autowired
    private  ReviewIssuedDetailDao issuedDetailDao;

    /**
     * 提交前回调
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        log.info("------------管理评审上报后后回调------------>");
        ReviewIssuedDetailEntity reviewIssuedDetail = issuedDetailDao.getById(billId);
        if (Objects.isNull(reviewIssuedDetail)) {
            log.info("------------未查询到审核记录------------>");
            return CommonResponse.success();
        }
        reviewIssuedDetail.setState("已上报");
        issuedDetailDao.updateById(reviewIssuedDetail);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//        log.info("------------管理评审终审后回调------------>");
//        ReviewIssuedDetailEntity reviewIssuedDetail = issuedDetailDao.getById(billId);
//        if (Objects.isNull(reviewIssuedDetail)) {
//            log.info("------------未查询到审核记录------------>");
//            return CommonResponse.success();
//        }
//        Long issuedId = reviewIssuedDetail.getIssuedId();
//        ReviewIssuedEntity issued = issuedDao.getById(issuedId);
//        /*
//          说明不是下达的任务
//         */
//        if (Objects.isNull(issued) || Objects.isNull(issuedId)) {
//            return CommonResponse.success();
//        }
//
//        //查询出所有该任务id(除本次上报的信息)的详情列表
//        List<ReviewIssuedDetailEntity> list = issuedDetailDao.lambdaQuery()
//                .eq(ReviewIssuedDetailEntity::getIssuedId, issuedId)
//                .ne(BaseEntity::getId, billId)
//                .list();
//        //过滤得到未完成的
//        List<ReviewIssuedDetailEntity> collect = list.stream()
//                .filter(e -> "未上报".equals(e.getState()))
//                .collect(Collectors.toList());
//        if (collect.isEmpty()) {
//            issued.setCompletion("已完成");
//        } else {
//            issued.setCompletion("部分完成");
//        }
//        issuedDao.updateById(issued);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

}
