package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:36
 * @Description: 管理评审-报告
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_report")
public class ReviewReportEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 更新者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 上传者姓名
     */
    @TableField(value = "upload_user_name")
    private String uploadUserName;

    /**
     * 改进建议-文件主题
     */
    @TableField(value = "file_topic")
    private String fileTopic;

    /**
     * 改进建议-文件名称
     */
    @TableField(value = "file_name")
    private String fileName;

    /**
     * 改进建议-文件附件
     */
    @TableField(value = "file_attachment")
    private String fileAttachment;
    /**
     * 改进建议-上传项目
     */
    @TableField(value = "upload_project")
    private String uploadProject;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;
}
