package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/21 上午9:20
 * @Description: 经验反馈-下达
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ExpFeedBackIssuedVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 创建者姓名
     */
    private String updateUserName;

    /**
     * 归属类型
     */
    private String attributionType;

    /**
     * 专业
     */
    private String specialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 下达单位id
     */
    private List<String> releaseUnitsId;

    /**
     * 下达单位name
     */
    private List<String> releaseUnitsName;

    /**
     * 完成情况
     */
    private String completion;

    /**
     * 下达时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;

    /**
     * 子表信息
     */
    private List<ExpFeedbackIssuedDetailVo> detailList = new ArrayList<>();
}
