package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:36
 * @Description: 管理评审-计划
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewPlanVo extends BaseVO {

    /**
     * 评审计划-文件主题
     */
    private String fileTopic;

    /**
     * 内容
     */
    private String content;

    /**
     * 评审计划-评审计划文件名称
     */
    private String reviewPlanFileName;

    /**
     * 评审计划-评审计划文件
     */
    private String reviewPlanFile;

    /**
     * 评审计划-上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 评审计划-上传人
     */
    private String uploader;

    /**
     * 评审计划-上传项目
     */
    private String uploadProject;
}
