package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:36
 * @Description: 管理评审-报告
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewReportVo extends BaseVO {

    /**
     * 改进建议-文件主题
     */
    private String fileTopic;

    /**
     * 改进建议-文件名称
     */
    private String fileName;

    /**
     * 改进建议-文件附件
     */
    private String fileAttachment;

    /**
     * 改进建议-上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传项目
     */
    private String uploadProject;
}
