package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.dao.ReviewIssuedDao;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.service.ReviewIssuedServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:00
 */
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ReviewIssuedServerImpl implements ReviewIssuedServer {
    private final ReviewIssuedDao dao;
    private final SessionManager sessionManager;

    private final ReviewIssuedDetailDao detailDao;

    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;

    @Override
    public ReviewIssuedVo saveOrUpdate(ReviewIssuedVo saveOrUpdateVO) {

        ReviewIssuedEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewIssuedEntity.class);
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            entity.setCreateUserName(dao.getById(id).getCreateUserName());
        }

        entity.setCompletion("未完成");

        dao.saveOrUpdate(entity, false);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties(entity, reviewIssuedVo);

        return reviewIssuedVo;
    }

    @Override
    public void issued(List<Long> idList) {
        List<ReleaseUnitSettingsDetailEntity> list = releaseUnitSettingsDetailDao.lambdaQuery()
                .eq(ReleaseUnitSettingsDetailEntity::getType, "管理评审输入").list();
        if (list.isEmpty()) {
            throw new BusinessException("暂无管理评审输入下达配置，请先配置！");
        }
        List<ReviewIssuedEntity> issuedEntityList = dao.lambdaQuery().in(BaseEntity::getId, idList).list();
        List<Long> releaseUnitIds = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List<String> releaseUnitName = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());
        List<String> chargeList = list.stream().map(ReleaseUnitSettingsDetailEntity::getCharge).collect(Collectors.toList());
        List<String> chargeNameList = list.stream().map(ReleaseUnitSettingsDetailEntity::getChargeName).collect(Collectors.toList());

        issuedEntityList.forEach(e -> {
            e.setReleaseUnitsId(String.valueOf(releaseUnitIds));
            e.setReleaseUnitsName(String.valueOf(releaseUnitName));
        });
        dao.saveOrUpdateBatch(issuedEntityList);
        List<ReviewIssuedDetailEntity> saveEntityList = Lists.newArrayList();

        saveOrUpdateDetail(issuedEntityList, releaseUnitName, releaseUnitIds, chargeList, chargeNameList, saveEntityList);

        detailDao.saveOrUpdateBatch(saveEntityList);
    }

    private void saveOrUpdateDetail(List<ReviewIssuedEntity> issuedEntityList, List<String> releaseUnitsNameList,
                                    List<Long> releaseUnitsIdList, List<String> chargeList, List<String> chargeNameList,
                                    List<ReviewIssuedDetailEntity> saveEntityList) {
        for (ReviewIssuedEntity entity : issuedEntityList) {
            for (int i = 0; i < releaseUnitsNameList.size(); i++) {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                reviewIssuedDetailVo.setTopic(entity.getTopic());
                reviewIssuedDetailVo.setContent(entity.getContent());
                reviewIssuedDetailVo.setUploadUnitId(String.valueOf(releaseUnitsIdList.get(i)));
                reviewIssuedDetailVo.setUploadUnitName(releaseUnitsNameList.get(i));
                reviewIssuedDetailVo.setCharge(chargeList.get(i));
                reviewIssuedDetailVo.setChargeName(chargeNameList.get(i));
                reviewIssuedDetailVo.setCreateUserName(sessionManager.getUserContext().getUserName());
                reviewIssuedDetailVo.setOrgId(sessionManager.getUserContext().getOrgId());
                reviewIssuedDetailVo.setOrgName(sessionManager.getUserContext().getOrgName());
                ReviewIssuedDetailEntity saveEntity = BeanMapper.map(reviewIssuedDetailVo, ReviewIssuedDetailEntity.class);
                saveEntity.setIssuedId(entity.getId());
                saveEntity.setState("未上报");
                saveEntityList.add(saveEntity);
            }
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            detailDao.lambdaUpdate().in(ReviewIssuedDetailEntity::getIssuedId, ids).remove();
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewIssuedVo detail(Long id) {
        ReviewIssuedEntity reviewIssuedEntity = dao.selectById(id);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties(reviewIssuedEntity, reviewIssuedVo);
        List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, id)
                .list().stream().map(e -> {
                    ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                    BeanUtil.copyProperties(e, reviewIssuedDetailVo);
                    return reviewIssuedDetailVo;
                }).collect(Collectors.toList());
        reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
        return reviewIssuedVo;
    }

    @Override
    public IPage<ReviewIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "releaseUnitsName", "createUserName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewIssuedEntity> page = dao.queryPage(param, false);
        IPage<ReviewIssuedVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReviewIssuedVo> objects = Lists.newArrayList();

        for (ReviewIssuedEntity record : page.getRecords()) {
            ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
            BeanUtil.copyProperties(record, reviewIssuedVo);
            List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, record.getId())
                    .list().stream().map(e -> {
                        ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                        BeanUtil.copyProperties(e, reviewIssuedDetailVo);
                        return reviewIssuedDetailVo;
                    }).collect(Collectors.toList());
            reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);

            objects.add(reviewIssuedVo);
        }

        pageData.setRecords(objects);

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewIssuedEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewIssuedExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审下达导出失败：" + e.getMessage());
        }

    }
}
