package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


/**
* @Author: LCL
* @Date: 2024/6/22 下午3:45
* @Description: 管理评审下达
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_issued")
public class ReviewIssuedEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 创建者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 附件名称
     */
    @TableField(value = "issued_annex_name")
    private String issuedAnnexName;

    /**
     * 附件
     */
    @TableField(value = "issued_annex")
    private String issuedAnnex;

    /**
     * 下达单位id
     */
    @TableField(value = "release_units_id")
    private String releaseUnitsId;

    /**
     * 下达单位name
     */
    @TableField(value = "release_units_name")
    private String releaseUnitsName;

    /**
     * 完成情况
     */
    @TableField(value = "completion")
    private String completion;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;


    @TableField(exist = false)
    @SubEntity(serviceName = "ReviewIssuedDetailDaoImpl",pidName = "issuedId")
    private List<ReviewIssuedDetailEntity> detailList = new ArrayList<>();
}
