/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.dao.ReviewIssuedDao;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.service.ReviewIssuedServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ReviewIssuedServerImpl
implements ReviewIssuedServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewIssuedServerImpl.class);
    private final ReviewIssuedDao dao;
    private final SessionManager sessionManager;
    private final ReviewIssuedDetailDao detailDao;
    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;

    @Override
    public ReviewIssuedVo saveOrUpdate(ReviewIssuedVo saveOrUpdateVO) {
        UserContext userContext = this.sessionManager.getUserContext();
        ReviewIssuedEntity entity = (ReviewIssuedEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewIssuedEntity.class));
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ReviewIssuedEntity)((Object)this.dao.getById(id))).getCreateUserName());
        }
        entity.setCompletion("\u672a\u5b8c\u6210");
        this.dao.saveOrUpdate((Object)entity, false);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)reviewIssuedVo));
        return reviewIssuedVo;
    }

    @Override
    public void issued(List<Long> idList) {
        List list = ((LambdaQueryChainWrapper)this.releaseUnitSettingsDetailDao.lambdaQuery().eq(ReleaseUnitSettingsDetailEntity::getType, (Object)"\u7ba1\u7406\u8bc4\u5ba1\u8f93\u5165")).list();
        if (list.isEmpty()) {
            throw new BusinessException("\u6682\u65e0\u7ba1\u7406\u8bc4\u5ba1\u8f93\u5165\u4e0b\u8fbe\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
        }
        List issuedEntityList = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, idList)).list();
        List<Long> releaseUnitIds = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List<String> releaseUnitName = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());
        List<String> chargeList = list.stream().map(ReleaseUnitSettingsDetailEntity::getCharge).collect(Collectors.toList());
        List<String> chargeNameList = list.stream().map(ReleaseUnitSettingsDetailEntity::getChargeName).collect(Collectors.toList());
        issuedEntityList.forEach(e -> {
            e.setReleaseUnitsId(String.valueOf(releaseUnitIds));
            e.setReleaseUnitsName(String.valueOf(releaseUnitName));
        });
        this.dao.saveOrUpdateBatch(issuedEntityList);
        List saveEntityList = Lists.newArrayList();
        this.saveOrUpdateDetail(issuedEntityList, releaseUnitName, releaseUnitIds, chargeList, chargeNameList, saveEntityList);
        this.detailDao.saveOrUpdateBatch(saveEntityList);
    }

    private void saveOrUpdateDetail(List<ReviewIssuedEntity> issuedEntityList, List<String> releaseUnitsNameList, List<Long> releaseUnitsIdList, List<String> chargeList, List<String> chargeNameList, List<ReviewIssuedDetailEntity> saveEntityList) {
        for (ReviewIssuedEntity entity : issuedEntityList) {
            for (int i = 0; i < releaseUnitsNameList.size(); ++i) {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                reviewIssuedDetailVo.setTopic(entity.getTopic());
                reviewIssuedDetailVo.setContent(entity.getContent());
                reviewIssuedDetailVo.setUploadUnitId(String.valueOf(releaseUnitsIdList.get(i)));
                reviewIssuedDetailVo.setUploadUnitName(releaseUnitsNameList.get(i));
                reviewIssuedDetailVo.setCharge(chargeList.get(i));
                reviewIssuedDetailVo.setChargeName(chargeNameList.get(i));
                reviewIssuedDetailVo.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                reviewIssuedDetailVo.setOrgId(this.sessionManager.getUserContext().getOrgId());
                reviewIssuedDetailVo.setOrgName(this.sessionManager.getUserContext().getOrgName());
                ReviewIssuedDetailEntity saveEntity = (ReviewIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)reviewIssuedDetailVo), ReviewIssuedDetailEntity.class));
                saveEntity.setIssuedId(entity.getId());
                saveEntity.setState("\u672a\u4e0a\u62a5");
                saveEntityList.add(saveEntity);
            }
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids, true);
            ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(ReviewIssuedDetailEntity::getIssuedId, ids)).remove();
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewIssuedVo detail(Long id) {
        ReviewIssuedEntity reviewIssuedEntity = (ReviewIssuedEntity)((Object)this.dao.selectById(id));
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties((Object)((Object)reviewIssuedEntity), (Object)((Object)reviewIssuedVo));
        List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, new Object[]{id})).list().stream().map(e -> {
            ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
            BeanUtil.copyProperties((Object)e, (Object)((Object)reviewIssuedDetailVo));
            return reviewIssuedDetailVo;
        }).collect(Collectors.toList());
        reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
        return reviewIssuedVo;
    }

    @Override
    public IPage<ReviewIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "releaseUnitsName", "createUserName"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List objects = Lists.newArrayList();
        for (ReviewIssuedEntity record : page.getRecords()) {
            ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
            BeanUtil.copyProperties((Object)((Object)record), (Object)((Object)reviewIssuedVo));
            List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, new Object[]{record.getId()})).list().stream().map(e -> {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                BeanUtil.copyProperties((Object)e, (Object)((Object)reviewIssuedDetailVo));
                return reviewIssuedDetailVo;
            }).collect(Collectors.toList());
            reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
            objects.add(reviewIssuedVo);
        }
        pageData.setRecords(objects);
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewIssuedExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u4e0b\u8fbe\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewIssuedServerImpl(ReviewIssuedDao dao, SessionManager sessionManager, ReviewIssuedDetailDao detailDao, ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao) {
        this.dao = dao;
        this.sessionManager = sessionManager;
        this.detailDao = detailDao;
        this.releaseUnitSettingsDetailDao = releaseUnitSettingsDetailDao;
    }
}

