package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewAnnexVo;
import com.ejianc.business.quality.service.ReviewAnnexServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;



/**
* @Author: LCL
* @Date: 2024/6/22 下午2:59
* @Description: 管理评审输入信息模板(管理评审-附件)
*/
@Controller
@RequestMapping("reviewAnnex")
@RequiredArgsConstructor
public class ReviewAnnexController {
    private final ReviewAnnexServer server;
    /**
     * 新增或编辑
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewAnnexVo> saveOrUpdate(@RequestBody ReviewAnnexVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", server.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> del(@RequestBody List<Long> ids) {
        return server.del(ids);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewAnnexVo> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("管理评审附件-详情", server.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewAnnexVo>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("管理评审附件-查询", server.list(param));
    }

}
