package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.StringJoiner;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 适用范围(公司部门 、 公司直管项目 、 公司所属单位 / 项目)
 */
@Getter
@AllArgsConstructor
public enum ApplicableScopeEnum {
    /**
     * 公司部门
     */
    DEPARTMENT("DEPARTMENT", "公司部门"),
    /**
     * 公司直管项目
     */
    STRAIGHTPIPES("STRAIGHTPIPES", "公司直管项目"),
    /**
     * 公司所属单位/项目
     */
    AFFILIATIONPROJECT("AFFILIATIONPROJECT", "公司所属单位/项目"),
    ;

    private final String scopeCode;

    private final String scopeName;

    public static final ApplicableScopeEnum[] VALUES;

    static {
        VALUES = values();
    }
    public static String getNameByCode(String scopeCode) {
        JSONArray objects = JSONUtil.parseArray(scopeCode, true);
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object object : objects) {
            for (ApplicableScopeEnum applicableScopeEnum : values()) {
                if (applicableScopeEnum.getScopeCode().equals(object)) {
                    stringJoiner.add(applicableScopeEnum.getScopeName());
                }
            }
        }
        return stringJoiner.toString();
    }
}
