package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewAnnexVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:00
 * @Description: 管理评审-模版
 */
public interface ReviewAnnexServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ReviewAnnexVo
     */
    ReviewAnnexVo saveOrUpdate(ReviewAnnexVo saveOrUpdateVO);

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    CommonResponse<Object> del(List<Long> ids);

    /**
     * 详情
     *
     * @param id id
     * @return ReviewAnnexVo
     */
    ReviewAnnexVo detail(Long id);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReviewAnnexVo>
     */
    IPage<ReviewAnnexVo> list(QueryParam param);
}
