package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ReviewIssuedDetailServer;
import com.ejianc.business.quality.service.ReviewIssuedServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/24 下午2:19
 * @Description: 管理评审
 */
@Controller
@RequestMapping("review")
@RequiredArgsConstructor
public class ReviewController {
    /**
     * 下达 issued
     */
    private final ReviewIssuedServer issuedServer;
    /**
     * 下达详情 issuedDetail
     */
    private final ReviewIssuedDetailServer issuedDetailServer;

    /*--------------------------------下达 issued--------------------------------*/

    /**
     * 新增或编辑
     */
    @RequestMapping(value = "issued/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewIssuedVo> saveOrUpdate(@RequestBody ReviewIssuedVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", issuedServer.saveOrUpdate(saveOrUpdateVO));
    }
    /**
     * 下达
     */
    @RequestMapping(value = "issued/issued", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ReviewIssuedDetailEntity>> issued(@RequestBody List<Long> idList) {
        return CommonResponse.success("下达成功！",issuedServer.issued(idList));
    }
    /**
     * 批量提交
     */
    @RequestMapping(value = "issued/batchSubmit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> batchSubmit(@RequestBody BatchSubmitVO batchSubmitVO) {
        return issuedServer.batchSubmit(batchSubmitVO);
    }

    /**
     * 删除
     */
    @RequestMapping(value = "issued/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> del(@RequestBody List<Long> ids) {
        return issuedServer.del(ids);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "issued/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewIssuedVo> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("管理评审下达-详情", issuedServer.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "issued/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewIssuedVo>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("管理评审下达-查询", issuedServer.list(param));
    }

    /**
     * 导出
     */
    @RequestMapping(value = "issued/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        issuedServer.excelExport(ids, response);
        return CommonResponse.success("管理评审下达-导出成功");
    }


    /*--------------------------------下达详情 --------------------------------*/

    /**
     * 新增或编辑
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewIssuedDetailVo> detailSaveOrUpdate(@RequestBody ReviewIssuedDetailVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", issuedDetailServer.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> detailDel(@RequestBody List<Long> ids) {
        return issuedDetailServer.del(ids);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewIssuedDetailVo> detailDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("管理评审-详情", issuedDetailServer.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewIssuedDetailVo>> detailList(@RequestBody QueryParam param) {
        return CommonResponse.success("管理评审-查询", issuedDetailServer.list(param));
    }

    /**
     * 导出
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> detailExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        issuedDetailServer.excelExport(ids, response);
        return CommonResponse.success("管理评审-导出成功");
    }

}
