package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.ArrayList;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/20 上午10:02
 * @Description: 经验反馈下达
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_issued")
public class ExpFeedbackIssuedEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 创建者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 归属类型
     */
    @TableField(value = "attribution_type")
    private String attributionType;

    /**
     * 专业
     */
    @TableField(value = "specialized")
    private String specialized;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 下达单位id
     */
    @TableField(value = "release_units_id")
    private String releaseUnitsId;

    /**
     * 下达单位name
     */
    @TableField(value = "release_units_name")
    private String releaseUnitsName;

    /**
     * 完成情况
     */
    @TableField(value = "completion")
    private String completion;

    /**
     * 下达时间
     */
    @TableField(value = "release_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;


    @TableField(exist = false)
    @SubEntity(serviceName = "ExpFeedbackIssuedDetailDaoImpl",pidName = "issuedId")
    private List<ExpFeedbackIssuedDetailEntity> detailList = new ArrayList<>();
}
