package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.service.ReviewIssuedDetailServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:00
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewIssuedDetailServerImpl implements ReviewIssuedDetailServer {
    private final ReviewIssuedDetailDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewIssuedDetailVo saveOrUpdate(ReviewIssuedDetailVo saveOrUpdateVO) {
        ReviewIssuedDetailEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewIssuedDetailEntity.class);
        UserContext userContext = sessionManager.getUserContext();

        if (entity.getId() == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setState("未上报");
            entity.setUploadUnitId(String.valueOf(userContext.getOrgId()));
            entity.setUploadUnitName(userContext.getOrgName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(dao.getById(entity.getId()).getCreateUserName());
        }

        entity.setOrgId(userContext.getOrgId());
        entity.setOrgName(userContext.getOrgName());
        dao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReviewIssuedDetailVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewIssuedDetailVo detail(Long id) {
        ReviewIssuedDetailEntity reviewIssuedDetailEntity = dao.selectById(id);
        return BeanMapper.map(reviewIssuedDetailEntity, ReviewIssuedDetailVo.class);
    }

    @Override
    public IPage<ReviewIssuedDetailVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "annexName", "uploadUnitName", "remark"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        param.getParams().put("charge", new Parameter(QueryParam.LIKE, sessionManager.getUserContext().getUserId()));

        IPage<ReviewIssuedDetailEntity> page = dao.queryPage(param, false);
        IPage<ReviewIssuedDetailVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewIssuedDetailVo.class));

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewIssuedDetailEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewDetailExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审导出失败：" + e.getMessage());
        }
    }
}
