package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:45
 * @Description: 管理评审下达
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewIssuedVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String content;

    /**
     * 附件名称
     */
    private String issuedAnnexName;

    /**
     * 附件
     */
    private String issuedAnnex;

    /**
     * 下达单位id
     */
    private List<String> releaseUnitsId;

    /**
     * 下达单位name
     */
    private List<String> releaseUnitsName;

    /**
     * 完成情况
     */
    private String completion;

    /**
     * 单据编号
     */
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    private Integer billState;

    /**
     * 子表
     */
    private List<ReviewIssuedDetailVo> detailList = new ArrayList<>();
}
