package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
* @Author: LCL
* @Date: 2024/6/22 下午3:45
* @Description: 管理评审下达详情
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewIssuedDetailVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 创建者姓名
     */
    private String updateUserName;
    /**
     * 管理评审下达id
     */
    private Long issuedId;

    /**
     * 上传单位id
     */
    private String uploadUnitId;

    /**
     * 上传单位名称
     */
    private String uploadUnitName;

    /**
     * 负责人
     */
    private String charge;

    /**
     * 负责人名称
     */
    private String chargeName;

    /**
     * 主题
     */
    private String topic;
    /**
     * 内容
     */
    private String content;
    /**
     * 备注
     */
    private String remark;
    /**
     * 改进建议
     */
    private String advice;

    /**
     * 附件名称
     */
    private String annexName;

    /**
     * 附件
     */
    private String annex;

    /**
     * 上报状态（已上报 未上报）
     */
    private String state;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 单据编号
     */
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    private Integer billState;
}
