package com.ejianc.business.quality.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:36
 * @Description: 管理评审-报告
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewReportVo extends BaseVO {

    /**
     * 改进建议-文件主题
     */
    private String fileTopic;

    /**
     * 改进建议-文件名称
     */
    private String fileName;

    /**
     * 内容
     */
    private String content;

    /**
     * 改进建议-文件附件
     */
    private String fileAttachment;

    /**
     * 改进建议-上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传项目
     */
    private String uploadProject;


    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;

    /**
     * 单据编号
     */
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    private Integer billState;
}
