/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.service.ReviewIssuedDetailServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReviewIssuedDetailServerImpl
implements ReviewIssuedDetailServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewIssuedDetailServerImpl.class);
    private final ReviewIssuedDetailDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewIssuedDetailVo saveOrUpdate(ReviewIssuedDetailVo saveOrUpdateVO) {
        ReviewIssuedDetailEntity entity = (ReviewIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewIssuedDetailEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        if (entity.getId() == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setState("\u672a\u4e0a\u62a5");
            entity.setUploadUnitId(String.valueOf(userContext.getOrgId()));
            entity.setUploadUnitName(userContext.getOrgName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ReviewIssuedDetailEntity)((Object)this.dao.getById(entity.getId()))).getCreateUserName());
        }
        entity.setOrgId(userContext.getOrgId());
        entity.setOrgName(userContext.getOrgName());
        this.dao.saveOrUpdate((Object)entity, false);
        return (ReviewIssuedDetailVo)((Object)BeanMapper.map((Object)((Object)entity), ReviewIssuedDetailVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewIssuedDetailVo detail(Long id) {
        ReviewIssuedDetailEntity reviewIssuedDetailEntity = (ReviewIssuedDetailEntity)((Object)this.dao.selectById(id));
        return (ReviewIssuedDetailVo)((Object)BeanMapper.map((Object)((Object)reviewIssuedDetailEntity), ReviewIssuedDetailVo.class));
    }

    @Override
    public IPage<ReviewIssuedDetailVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "annexName", "uploadUnitName", "remark"));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("charge", new Parameter("like", (Object)this.sessionManager.getUserContext().getUserId()));
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewIssuedDetailVo.class));
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewDetailExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewIssuedDetailServerImpl(ReviewIssuedDetailDao dao, SessionManager sessionManager) {
        this.dao = dao;
        this.sessionManager = sessionManager;
    }
}

