package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/24 下午2:13
 * @Description: 管理评审下达
 */
public interface ReviewIssuedServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ReviewIssuedVo
     */
    ReviewIssuedVo saveOrUpdate(ReviewIssuedVo saveOrUpdateVO);

    /**
     * 下达接口
     *
     * @param idList 主信息id
     * @return
     */
    List<ReviewIssuedDetailEntity> issued(List<Long> idList);

    /**
     * 批量提交
     *
     * @param vo BatchSubmitVO
     * @return 结果
     */
    CommonResponse<Object> batchSubmit(BatchSubmitVO vo);

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    CommonResponse<Object> del(List<Long> ids);

    /**
     * 详情
     *
     * @param id    id
     * @param state
     * @return ReviewIssuedVo
     */
    ReviewIssuedVo detail(Long id, String state);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReviewIssuedVo>
     */
    IPage<ReviewIssuedVo> list(QueryParam param);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    void excelExport(List<Long> ids, HttpServletResponse response);
}
