package com.ejianc.business.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.CompanyGoalsEntity;
import com.ejianc.business.quality.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quality.model.vo.CompanyTargetEditVo;
import com.ejianc.business.quality.service.TargetManagementServer;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/13 下午1:45
 * @Description: 目标管理
 */
@Controller
@RequestMapping("targetManagement")
@RequiredArgsConstructor
public class TargetManagementController {
    private final TargetManagementServer server;

    /**
     * 目标管理-新增
     *
     * @param vo CompanyTargetAddVo
     * @return CompanyGoalsEntity
     * @see CompanyTargetAddVo
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyGoalsEntity> companyAdd(@RequestBody @Valid CompanyTargetAddVo vo) {
        return CommonResponse.success("目标管理-新增成功", server.companyAdd(vo));
    }

    /**
     * 目标管理-编辑
     *
     * @param vo CompanyTargetEditVo
     * @return 结果
     * @see CompanyTargetEditVo
     */
    @RequestMapping(value = "edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyGoalsEntity> companyEdit(@RequestBody @Valid CompanyTargetEditVo vo) {
        return CommonResponse.success("目标管理-编辑成功", server.companyEdit(vo));
    }

    /**
     * 目标管理-查询
     *
     * @param param param
     * @return IPage<CompanyGoalsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyGoalsEntity>> companyList(@RequestBody QueryParam param) {
        return CommonResponse.success("目标管理-查询", server.companyList(param));
    }

    /**
     * 目标管理-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyGoalsEntity> companyDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("目标管理-查询", server.companyDetail(id));
    }

    /**
     * 目标管理-删除
     *
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyDel(@RequestBody List<CompanyGoalsEntity> vos) {
        server.companyDel(vos);
        return CommonResponse.success("目标管理-删除成功");
    }

    /**
     * 目标管理-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.companyExcelExport(ids, response);
        return CommonResponse.success("目标管理-导出成功");
    }

    /**
     * 目标管理导入
     *
     * @return 结果
     */
    @RequestMapping(value = "excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> companyExcelImport(HttpServletRequest request) {
        return server.companyExcelImport(request);
    }

    /**
     * 目标管理导入保存
     *
     * @return 结果
     */
    @RequestMapping(value = "excelImport/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> companyExcelImportSave(@RequestBody List<CompanyGoalsEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        server.companyExcelImportSave(importVos);
        return CommonResponse.success("目标管理-导入成功");
    }

}
