package com.ejianc.business.quality.model.vo;

import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/17 上午9:53
 * @Description: 体系文件-制度库编辑入参
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SysDocInstitutionalEditVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 来源(OA、ZTPC)
     *
     * @see SystemDocumentsOriginEnum
     */
    @Builder.Default
    private String origin = SystemDocumentsOriginEnum.ZTPC.getOriginCode();

    /**
     * 编制部门
     */
    private BaseInfoVo bzbm;

    /**
     * 编制单位
     */
    private BaseInfoVo bzdw;

    /**
     * 制度标题
     */
    private String zdbt;

    /**
     * 制度正文 url地址
     */
    private String zdzw;

    /**
     * 制度版本(V V1 V2 V3 V4 V5 V6 V7 V8 V9 V10)
     *
     * @see com.ejianc.business.quality.enums.SystemDocumentsStatusEnum
     */
    private String zdbb;

    /**
     * 发文号
     */
    private String fwh;

    /**
     * 制度编码
     */
    private String zdbm;

    /**
     * 发布日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fbrq;

    /**
     * 审议机构
     */
    private String syjg;

    /**
     * 审批机构
     */
    private String spjg;

    /**
     * 状态(施行、试行、废止)
     *
     * @see com.ejianc.business.quality.enums.SystemDocumentsStatusEnum
     */
    private String zt;

    /**
     * 公司本部(本部适用、规范至所属单位、规范至所属法人企业)
     */
    private String gsbb;

    /**
     * 子公司(遵照执行、细化执行、参照执行、不适用)
     */
    private String zgs;

    /**
     * 分公司(遵照执行、细化执行、参照执行、不适用)
     */
    private String fgs;

    /**
     * 直管项目(遵照执行、细化执行、参照执行、不适用)
     */
    private String zgxm;

    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quality.enums.ManagementSystemEnum
     */
    @NotEmpty(message = "归属管理体系不能为空")
    private String gltx;

    /**
     * 编码
     */
    private String bm;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人不能为空")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;
}
