package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReleaseUnitSettingsVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 目标管理
 */
public interface ReleaseUnitSettingServer {

    CommonResponse<Object> saveOrUpdate(ReleaseUnitSettingsVo saveOrUpdateVO);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReleaseUnitSettingsEntity>
     */
    IPage<ReleaseUnitSettingsVo> list(QueryParam param);

    /**
     * 详情
     *
     * @param id id
     * @return ReleaseUnitSettingsEntity
     */
    ReleaseUnitSettingsVo detail(Long id);

    /**
     * 删除
     *
     * @param vos vos
     */
    void del(List<ReleaseUnitSettingsVo> vos);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    void excelExport(List<Long> ids, HttpServletResponse response);
}
