/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quality.model.vo.ReleaseUnitSettingsDetailVo;
import com.ejianc.business.quality.model.vo.ReleaseUnitSettingsVo;
import com.ejianc.business.quality.service.ReleaseUnitSettingServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;

@Service
public class ReleaseUnitSettingServerImpl
implements ReleaseUnitSettingServer {
    private static final Logger log = LoggerFactory.getLogger(ReleaseUnitSettingServerImpl.class);
    private final ReleaseUnitSettingsDao dao;
    private final ReleaseUnitSettingsDetailDao detailDao;
    private final SessionManager sessionManager;
    private final JedisPool jedisPool;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<Object> saveOrUpdate(ReleaseUnitSettingsVo saveOrUpdateVO) {
        ReleaseUnitSettingsEntity entity = (ReleaseUnitSettingsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReleaseUnitSettingsEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        Long id = entity.getId();
        String type = entity.getType();
        List<ReleaseUnitSettingsDetailEntity> subList = entity.getSubList();
        if (id == null) {
            boolean locked = false;
            Jedis jedis = (Jedis)this.jedisPool.getResource();
            String key = saveOrUpdateVO.getCreateUserCode() + "ReleaseUnitSettingAdd";
            ReleaseUnitSettingsEntity one = (ReleaseUnitSettingsEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(ReleaseUnitSettingsEntity::getType, (Object)type)).one());
            if (Objects.nonNull((Object)one)) {
                throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u914d\u7f6e");
            }
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)RandomUtil.randomNumbers((int)10), (int)1000);
                if (!locked) {
                    log.error("\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u65b0\u589e\u5931\u8d25\uff0c\u91cd\u590d\u6dfb\u52a0\uff0c\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                    this.releaseLock(jedis, false, key, "\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u65b0\u589e");
                    CommonResponse commonResponse = CommonResponse.error((String)"\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u65b0\u589e\u5931\u8d25\uff0c\u91cd\u590d\u6dfb\u52a0!");
                    return commonResponse;
                }
                entity.setOrgId(userContext.getOrgId());
                entity.setOrgName(userContext.getOrgName());
                entity.setCreateUserName(userContext.getUserName());
                entity.setPreparedUserCode(userContext.getUserCode());
                subList.forEach(e -> e.setCharge(e.getCharge() + ","));
                this.dao.saveOrUpdate((Object)entity, false);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().set(ReleaseUnitSettingsDetailEntity::getType, (Object)entity.getType())).set(BaseEntity::getCreateUserCode, (Object)entity.getCreateUserCode())).eq(ReleaseUnitSettingsDetailEntity::getSettingId, (Object)entity.getId())).update();
            }
            catch (Exception e2) {
                throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e2.getMessage());
            }
            finally {
                this.releaseLock(jedis, locked, key, "\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u65b0\u589e");
            }
        }
        ReleaseUnitSettingsEntity one = (ReleaseUnitSettingsEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(ReleaseUnitSettingsEntity::getType, (Object)type)).one());
        if (Objects.nonNull((Object)one) && !one.getId().equals(id)) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u914d\u7f6e");
        }
        try {
            entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            subList.forEach(e -> {
                e.setCharge(e.getCharge() + ",");
                e.setType(type);
            });
            this.dao.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e3) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e3.getMessage());
        }
        return CommonResponse.success((String)"\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e-\u65b0\u589e/\u7f16\u8f91\u6210\u529f", (Object)BeanMapper.map((Object)((Object)entity), ReleaseUnitSettingsVo.class));
    }

    @Override
    public IPage<ReleaseUnitSettingsVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList(new String[0]));
        param.getOrderMap().put("createTime", "desc");
        IPage settingsEntityPage = this.dao.queryPage(param, false);
        List records = settingsEntityPage.getRecords();
        if (records.isEmpty()) {
            return new Page(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal());
        }
        List ids = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List detalList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReleaseUnitSettingsDetailEntity::getSettingId, ids)).list();
        if (detalList.isEmpty()) {
            return new Page(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal());
        }
        Map<Long, List<ReleaseUnitSettingsDetailEntity>> idAndSubListMap = detalList.stream().collect(Collectors.groupingBy(ReleaseUnitSettingsDetailEntity::getSettingId));
        List childList = Lists.newArrayList();
        ArrayList res = new ArrayList(Collections.emptyList());
        for (ReleaseUnitSettingsEntity record : records) {
            ReleaseUnitSettingsVo releaseUnitSettingsVo = new ReleaseUnitSettingsVo();
            BeanUtils.copyProperties((Object)((Object)record), (Object)((Object)releaseUnitSettingsVo));
            if (!idAndSubListMap.containsKey(record.getId())) continue;
            idAndSubListMap.get(releaseUnitSettingsVo.getId()).forEach(e -> childList.add(BeanMapper.map((Object)e, ReleaseUnitSettingsDetailVo.class)));
            releaseUnitSettingsVo.setSubList(childList);
            res.add(releaseUnitSettingsVo);
        }
        return new Page(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal()).setRecords(res);
    }

    @Override
    public ReleaseUnitSettingsVo detail(Long id) {
        ReleaseUnitSettingsEntity byId = (ReleaseUnitSettingsEntity)((Object)this.dao.getById(id));
        ReleaseUnitSettingsVo releaseUnitSettingsVo = new ReleaseUnitSettingsVo();
        if (Objects.isNull((Object)byId)) {
            return releaseUnitSettingsVo;
        }
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)releaseUnitSettingsVo));
        List child = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().eq(ReleaseUnitSettingsDetailEntity::getSettingId, (Object)id)).list();
        List childList = Lists.newArrayList();
        child.forEach(e -> childList.add(BeanMapper.map((Object)e, ReleaseUnitSettingsDetailVo.class)));
        releaseUnitSettingsVo.setSubList(childList);
        return releaseUnitSettingsVo;
    }

    @Override
    public void del(List<ReleaseUnitSettingsVo> vos) {
        try {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dao.lambdaUpdate().set(BaseEntity::getDr, (Object)1)).in(BaseEntity::getId, ids)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().set(BaseEntity::getDr, (Object)1)).eq(ReleaseUnitSettingsDetailEntity::getSettingId, ids)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReleaseUnitSettingsDetailEntity::getSettingId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("releaseUnitSettingExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0b\u8fbe\u5355\u4f4d\u8bbe\u7f6e\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)operate);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public ReleaseUnitSettingServerImpl(ReleaseUnitSettingsDao dao, ReleaseUnitSettingsDetailDao detailDao, SessionManager sessionManager, JedisPool jedisPool) {
        this.dao = dao;
        this.detailDao = detailDao;
        this.sessionManager = sessionManager;
        this.jedisPool = jedisPool;
    }
}

