package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedBackIssuedVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackStudyBankVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ExpFeedbackBankServer;
import com.ejianc.business.quality.service.ExpFeedbackIssuedDetailServer;
import com.ejianc.business.quality.service.ExpFeedbackIssuedServer;
import com.ejianc.business.quality.service.ExpFeedbackStudyBankServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:08
 * @Description: 经验反馈
 */
@Controller
@RequestMapping("experienceFeedback")
@RequiredArgsConstructor
public class ExpFeedbackController {
    private final ExpFeedbackIssuedServer issuedServer;
    private final ExpFeedbackIssuedDetailServer detailServer;
    private final ExpFeedbackBankServer bankServer;
    private final ExpFeedbackStudyBankServer studyBankServer;

    /*--------------------------------下达 issued--------------------------------*/

    /**
     * 新增或编辑
     */
    @RequestMapping(value = "issued/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpFeedBackIssuedVo> issuedSaveOrUpdate(@RequestBody ExpFeedBackIssuedVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", issuedServer.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 下达
     */
    @RequestMapping(value = "issued/issued", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExperienceFeedbackIssuedDetailEntity>> issued(@RequestBody List<Long> idList) {
        return CommonResponse.success("下达成功！", issuedServer.issued(idList));
    }

    /**
     * 批量提交
     */
    @RequestMapping(value = "issued/batchSubmit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> batchSubmit(@RequestBody BatchSubmitVO batchSubmitVO) {
        return issuedServer.batchSubmit(batchSubmitVO);
    }


    /**
     * 删除
     */
    @RequestMapping(value = "issued/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> issuedDel(@RequestBody List<ExpFeedBackIssuedVo> vo) {
        return issuedServer.del(vo);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "issued/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpFeedBackIssuedVo> issuedDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "state") String state) {
        return CommonResponse.success("经验反馈下达-详情", issuedServer.detail(id, state));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "issued/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpFeedBackIssuedVo>> issuedList(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈下达-查询", issuedServer.list(param));
    }

    /**
     * 导出
     */
    @RequestMapping(value = "issued/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        issuedServer.excelExport(ids, response);
        return CommonResponse.success("经验反馈下达-导出成功");
    }


    /*--------------------------------下达详情 --------------------------------*/

    /**
     * 新增或编辑
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpFeedbackIssuedDetailVo> saveOrUpdate(@RequestBody ExpFeedbackIssuedDetailVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", detailServer.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> del(@RequestBody List<ExpFeedbackIssuedDetailVo> vos) {
        return detailServer.del(vos);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpFeedbackIssuedDetailVo> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈-详情", detailServer.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpFeedbackIssuedDetailVo>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈-查询", detailServer.list(param));
    }

    /**
     * 导出
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        detailServer.excelExport(ids, response);
        return CommonResponse.success("经验反馈-导出成功");
    }

    /*--------------------------------经验库 bank--------------------------------*/

    /**
     * 入库
     */
    @RequestMapping(value = "bank/enter", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExpFeedbackBankVo>> bankEnter(@RequestBody List<Long> ids) {
        return bankServer.enterBank(ids);
    }
//
//    /**
//     * 新增或编辑
//     */
//    @RequestMapping(value = "bank/saveOrUpdate", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<ExpFeedbackBankVo> bankSaveOrUpdate(@RequestBody ExpFeedbackBankVo saveOrUpdateVO) {
//        return CommonResponse.success("保存或修改单据成功！", bankServer.saveOrUpdate(saveOrUpdateVO));
//    }
//
//    /**
//     * 删除
//     */
//    @RequestMapping(value = "bank/del", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<Object> bankDel(@RequestBody List<Long> ids) {
//        return bankServer.del(ids);
//    }
//

    /**
     * 详情
     */
    @RequestMapping(value = "bank/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpFeedbackBankVo> bankDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈库-详情", bankServer.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "bank/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpFeedbackBankVo>> bankList(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈库-查询", bankServer.list(param));
    }

    /*--------------------------------学习库--------------------------------*/


    /**
     * 新增或编辑
     */
    @RequestMapping(value = "studyBank/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpFeedbackStudyBankVo> studyBankSaveOrUpdate(@RequestBody ExpFeedbackStudyBankVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", studyBankServer.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "studyBank/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> studyBankDel(@RequestBody List<ExpFeedbackStudyBankVo> vos) {
        return studyBankServer.del(vos);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "studyBank/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpFeedbackStudyBankVo> studyBankDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈学习库-详情", studyBankServer.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "studyBank/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpFeedbackStudyBankVo>> studyBankList(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈学习库-查询", studyBankServer.list(param));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "studyBank/enter", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExpFeedbackStudyBankVo>> studyBankEnter(@RequestBody List<Long> ids) {
        return studyBankServer.enterBank(ids);
    }

}
