package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/9/27 上午8:36
 * @Description: 经验反馈学习库
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_study_bank")
public class ExpFeedbackStudyBankEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 更新着姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 板块
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 附件
     */
    @TableField(value = "annex")
    private String annex;

    /**
     * 附件名称
     */
    @TableField(value = "annex_name")
    private String annexName;

    /**
     * 入库状态
     */
    @TableField(value = "warehousing_state")
    private String warehousingState;
    /**
     * 入库人
     */
    @TableField(value = "warehousing_person")
    private Long warehousingPerson;

    /**
     * 入库人
     */
    @TableField(value = "warehousing_person_name")
    private String warehousingPersonName;

    /**
     * 入库时间
     */
    @TableField(value = "warehousing_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date warehousingTime;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳rn回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
