/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ExpFeedbackStudyBankDao;
import com.ejianc.business.quality.entity.ExpFeedbackStudyBankEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackStudyBankVo;
import com.ejianc.business.quality.service.ExpFeedbackStudyBankServer;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ExpFeedbackStudyBankServerImpl
implements ExpFeedbackStudyBankServer {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackStudyBankServerImpl.class);
    private final ExpFeedbackStudyBankDao studyBankDao;
    private final SessionManager sessionManager;
    @Autowired
    @Qualifier(value="com.ejianc.foundation.support.api.IBillCodeApi")
    private IBillCodeApi iBillCodeApi;

    @Override
    public ExpFeedbackStudyBankVo saveOrUpdate(ExpFeedbackStudyBankVo saveOrUpdateVO) {
        ExpFeedbackStudyBankEntity entity = (ExpFeedbackStudyBankEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExpFeedbackStudyBankEntity.class));
        Long id = entity.getId();
        UserContext userContext = this.sessionManager.getUserContext();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setWarehousingState("\u672a\u5165\u5e93");
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
        }
        this.studyBankDao.saveOrUpdate((Object)entity, false);
        BillCodeParam billCodeParam = BillCodeParam.build((String)"EXP_STUDY_BANK", (Long)InvocationInfoProxy.getTenantid(), (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)entity))));
        CommonResponse billCode = this.iBillCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            entity.setCode((String)billCode.getData());
            this.studyBankDao.updateById((Object)entity);
        }
        return (ExpFeedbackStudyBankVo)((Object)BeanMapper.map((Object)((Object)entity), ExpFeedbackStudyBankVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<ExpFeedbackStudyBankVo> ids) {
        try {
            List delIdes = ids.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.studyBankDao.removeByIds(delIdes, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ExpFeedbackStudyBankVo detail(Long id) {
        ExpFeedbackStudyBankEntity expFeedbackStudyBankEntity = (ExpFeedbackStudyBankEntity)((Object)this.studyBankDao.selectById(id));
        return (ExpFeedbackStudyBankVo)((Object)BeanMapper.map((Object)((Object)expFeedbackStudyBankEntity), ExpFeedbackStudyBankVo.class));
    }

    @Override
    public IPage<ExpFeedbackStudyBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "substance", "content"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.studyBankDao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpFeedbackStudyBankVo.class));
        return pageData;
    }

    @Override
    public CommonResponse<List<ExpFeedbackStudyBankVo>> enterBank(List<Long> ids) {
        List list = ((LambdaQueryChainWrapper)this.studyBankDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(e -> {
            e.setWarehousingState("\u5df2\u5165\u5e93");
            e.setWarehousingPerson(this.sessionManager.getUserContext().getUserId());
            e.setWarehousingPersonName(this.sessionManager.getUserContext().getUserName());
            e.setWarehousingTime(new Date());
        });
        this.studyBankDao.updateBatchById(list);
        return CommonResponse.success((String)"\u5165\u5e93\u6210\u529f");
    }

    @Override
    public IPage<ExpFeedbackStudyBankVo> studyBankEnterList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "substance", "content"));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("warehousingState", new Parameter("eq", (Object)"\u5df2\u5165\u5e93"));
        IPage page = this.studyBankDao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpFeedbackStudyBankVo.class));
        return pageData;
    }

    public ExpFeedbackStudyBankServerImpl(ExpFeedbackStudyBankDao studyBankDao, SessionManager sessionManager) {
        this.studyBankDao = studyBankDao;
        this.sessionManager = sessionManager;
    }
}

