package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReleaseUnitSettingsVo;
import com.ejianc.business.quality.service.ReleaseUnitSettingServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:33
 * @Description: 下达单位设置
 */
@Controller
@RequestMapping("releaseUnitSetting")
@RequiredArgsConstructor
public class ReleaseUnitSettingController {
    private final ReleaseUnitSettingServer server;

    /**
     * 新增或编辑
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> saveOrUpdate(@RequestBody ReleaseUnitSettingsVo saveOrUpdateVO) {
        return server.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReleaseUnitSettingsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReleaseUnitSettingsVo>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("下达单位设置-查询", server.list(param));
    }

    /**
     * 详情
     *
     * @param id id
     * @return ReleaseUnitSettingsEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReleaseUnitSettingsVo> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("下达单位设置-查询", server.detail(id));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody List<ReleaseUnitSettingsVo> vos) {
        server.del(vos);
        return CommonResponse.success("下达单位设置-删除成功");
    }

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.excelExport(ids, response);
        return CommonResponse.success("下达单位设置-导出成功");
    }
}
