/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedBackIssuedVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ExpFeedbackIssuedServer;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Maps;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExpFeedbackIssuedServerImpl
implements ExpFeedbackIssuedServer {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackIssuedServerImpl.class);
    private final ExpFeedbackIssuedDao dao;
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;
    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;
    @Qualifier(value="com.ejianc.foundation.bpm.api.IBpmApi")
    private final IBpmApi iBpmApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ExpFeedBackIssuedVo saveOrUpdate(ExpFeedBackIssuedVo saveOrUpdateVO) {
        UserContext userContext = this.sessionManager.getUserContext();
        ExperienceFeedbackIssuedEntity entity = (ExperienceFeedbackIssuedEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExperienceFeedbackIssuedEntity.class));
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            entity.setIsIssued(false);
            entity.setCompletion("\u672a\u5b8c\u6210");
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ExperienceFeedbackIssuedEntity)((Object)this.dao.getById(id))).getCreateUserName());
        }
        this.dao.saveOrUpdate((Object)entity, false);
        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)expFeedBackIssuedVo));
        return expFeedBackIssuedVo;
    }

    @Override
    public List<ExperienceFeedbackIssuedDetailEntity> issued(List<Long> idList) {
        List settingsDetailEntityList = ((LambdaQueryChainWrapper)this.releaseUnitSettingsDetailDao.lambdaQuery().eq(ReleaseUnitSettingsDetailEntity::getType, (Object)"\u7ecf\u9a8c\u53cd\u9988")).list();
        if (settingsDetailEntityList.isEmpty()) {
            throw new BusinessException("\u6682\u65e0\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
        }
        List releaseUnitIds = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List releaseUnitName = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());
        List entityList = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, idList)).list();
        entityList.forEach(e -> {
            String releaseUnitIdsStr = StrUtil.toString((Object)releaseUnitIds).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsId(releaseUnitIdsStr);
            String releaseUnitNameStr = StrUtil.toString((Object)releaseUnitName).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsName(releaseUnitNameStr);
            e.setIsIssued(true);
        });
        this.dao.saveOrUpdateBatch(entityList);
        List saveEntityList = Lists.newArrayList();
        this.saveOrUpdateDetail(entityList, settingsDetailEntityList, saveEntityList);
        this.detailDao.saveOrUpdateBatch(saveEntityList);
        return saveEntityList;
    }

    private void saveOrUpdateDetail(List<ExperienceFeedbackIssuedEntity> entity, List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList, List<ExperienceFeedbackIssuedDetailEntity> saveEntityList) {
        UserContext userContext = this.sessionManager.getUserContext();
        for (ExperienceFeedbackIssuedEntity experienceFeedbackIssuedEntity : entity) {
            Long id = experienceFeedbackIssuedEntity.getId();
            String annex = experienceFeedbackIssuedEntity.getAnnex();
            String annexName = experienceFeedbackIssuedEntity.getAnnexName();
            String attributionType = experienceFeedbackIssuedEntity.getAttributionType();
            String specialized = experienceFeedbackIssuedEntity.getSpecialized();
            String topic = experienceFeedbackIssuedEntity.getTopic();
            String substance = experienceFeedbackIssuedEntity.getSubstance();
            for (ReleaseUnitSettingsDetailEntity unitSettingsDetailEntity : settingsDetailEntityList) {
                ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                expFeedbackIssuedDetailVo.setStudyAnnex(annex);
                expFeedbackIssuedDetailVo.setStudyAnnexName(annexName);
                expFeedbackIssuedDetailVo.setCreateUserName(userContext.getUserName());
                expFeedbackIssuedDetailVo.setIssuedId(id);
                expFeedbackIssuedDetailVo.setReleaseTime(new Date(System.currentTimeMillis()));
                expFeedbackIssuedDetailVo.setAttributionType(attributionType);
                expFeedbackIssuedDetailVo.setSpecialized(specialized);
                expFeedbackIssuedDetailVo.setTopic(topic);
                expFeedbackIssuedDetailVo.setSubstance(substance);
                expFeedbackIssuedDetailVo.setUploadDepartmentId(String.valueOf(unitSettingsDetailEntity.getReleaseUnits()));
                expFeedbackIssuedDetailVo.setUploadDepartmentName(unitSettingsDetailEntity.getReleaseUnitsName());
                expFeedbackIssuedDetailVo.setCharge(unitSettingsDetailEntity.getCharge());
                expFeedbackIssuedDetailVo.setChargeName(unitSettingsDetailEntity.getChargeName());
                expFeedbackIssuedDetailVo.setLeader(unitSettingsDetailEntity.getLeader());
                expFeedbackIssuedDetailVo.setLeaderName(unitSettingsDetailEntity.getLeaderName());
                expFeedbackIssuedDetailVo.setState("\u672a\u4e0a\u62a5");
                expFeedbackIssuedDetailVo.setLearnState("\u672a\u5b66\u4e60");
                expFeedbackIssuedDetailVo.setOrgId(userContext.getOrgId());
                expFeedbackIssuedDetailVo.setOrgName(userContext.getOrgName());
                expFeedbackIssuedDetailVo.setParentOrgId(userContext.getDeptId());
                expFeedbackIssuedDetailVo.setParentOrgName(userContext.getDeptName());
                ExperienceFeedbackIssuedDetailEntity saveEntity = (ExperienceFeedbackIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)expFeedbackIssuedDetailVo), ExperienceFeedbackIssuedDetailEntity.class));
                saveEntityList.add(saveEntity);
            }
        }
    }

    @Override
    public CommonResponse<Object> batchSubmit(BatchSubmitVO vo) {
        if (Objects.isNull(vo) || vo.getDetailList().isEmpty() || StrUtil.isEmpty((CharSequence)vo.getBillTypeCode())) {
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u53c2\u6570\u9519\u8bef");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                HashMap submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", this.baseHost + "/ejc-ztpczr-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "\u7ecf\u9a8c\u53cd\u9988" + detail.getId() + DateFormatUtils.format((java.util.Date)new java.util.Date(), (String)"yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse result = this.iBpmApi.doSubmit((Map)submitParam);
                if (result.isSuccess()) continue;
                return CommonResponse.error((String)result.getMsg());
            }
            return CommonResponse.success((String)"\u6279\u91cf\u63d0\u4ea4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Override
    public CommonResponse<Object> del(List<ExpFeedBackIssuedVo> vos) {
        try {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.dao.removeByIds(ids, true);
            ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, ids)).remove();
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ExpFeedBackIssuedVo detail(Long id, String state) {
        ExperienceFeedbackIssuedEntity experienceFeedbackIssuedEntity = (ExperienceFeedbackIssuedEntity)((Object)this.dao.selectById(id));
        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties((Object)((Object)experienceFeedbackIssuedEntity), (Object)((Object)expFeedBackIssuedVo));
        if (StrUtil.isNotBlank((CharSequence)experienceFeedbackIssuedEntity.getReleaseUnitsName())) {
            List strings = StrUtil.splitTrim((CharSequence)experienceFeedbackIssuedEntity.getReleaseUnitsName(), (CharSequence)",");
            expFeedBackIssuedVo.setReleaseUnitsName(strings);
            List strings1 = StrUtil.splitTrim((CharSequence)experienceFeedbackIssuedEntity.getReleaseUnitsId(), (CharSequence)",");
            expFeedBackIssuedVo.setReleaseUnitsId(strings1);
        }
        List<ExpFeedbackIssuedDetailVo> expFeedbackIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{id})).list().stream().map(e -> {
            ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
            BeanUtil.copyProperties((Object)e, (Object)((Object)expFeedbackIssuedDetailVo));
            return expFeedbackIssuedDetailVo;
        }).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)state)) {
            switch (state) {
                case "Y": {
                    expFeedbackIssuedDetailVoList = expFeedbackIssuedDetailVoList.stream().filter(e -> "\u5df2\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
                    break;
                }
                case "W": {
                    expFeedbackIssuedDetailVoList = expFeedbackIssuedDetailVoList.stream().filter(e -> "\u672a\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
                    break;
                }
            }
        }
        expFeedBackIssuedVo.setDetailList(expFeedbackIssuedDetailVoList);
        return expFeedBackIssuedVo;
    }

    @Override
    public IPage<ExpFeedBackIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "createUserName", "topic", "substance", "releaseUnitsName"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List objects = Lists.newArrayList();
        for (ExperienceFeedbackIssuedEntity record : page.getRecords()) {
            ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
            BeanUtil.copyProperties((Object)((Object)record), (Object)((Object)expFeedBackIssuedVo));
            if (StrUtil.isNotBlank((CharSequence)record.getReleaseUnitsName())) {
                List strings = StrUtil.splitTrim((CharSequence)record.getReleaseUnitsName(), (CharSequence)",");
                expFeedBackIssuedVo.setReleaseUnitsName(strings);
                List strings1 = StrUtil.splitTrim((CharSequence)record.getReleaseUnitsId(), (CharSequence)",");
                expFeedBackIssuedVo.setReleaseUnitsId(strings1);
            }
            List<ExpFeedbackIssuedDetailVo> reviewIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{record.getId()})).list().stream().map(e -> {
                ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                BeanUtil.copyProperties((Object)e, (Object)((Object)expFeedbackIssuedDetailVo));
                return expFeedbackIssuedDetailVo;
            }).collect(Collectors.toList());
            expFeedBackIssuedVo.setDetailList(reviewIssuedDetailVoList);
            objects.add(expFeedBackIssuedVo);
        }
        pageData.setRecords(objects);
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("expFeedbackIssuedExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ExpFeedbackIssuedServerImpl(ExpFeedbackIssuedDao dao, ExpFeedbackIssuedDetailDao detailDao, SessionManager sessionManager, ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao, IBpmApi iBpmApi) {
        this.dao = dao;
        this.detailDao = detailDao;
        this.sessionManager = sessionManager;
        this.releaseUnitSettingsDetailDao = releaseUnitSettingsDetailDao;
        this.iBpmApi = iBpmApi;
    }
}

