package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 上午9:14
 * @Description: 体系文件
 */

@Controller
@RequestMapping("systemDoc")
@RequiredArgsConstructor
public class SystemDocumentsController {
    private final SystemDocumentsServer server;

    /**
     * 标准库——新增
     *
     * @param vo SysDocStandardAddVo
     * @see SysDocStandardAddVo
     */
    @RequestMapping(value = "standard/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocStandardAddVo> standardAdd(@RequestBody @Valid SysDocStandardAddVo vo) {
        return CommonResponse.success("标准库——新增成功", server.standardAdd(vo));
    }

    /**
     * 制度库——新增
     *
     * @param vo SysDocInstitutionalAddVo
     * @see SysDocInstitutionalAddVo
     */
    @RequestMapping(value = "institutional/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocInstitutionalAddVo> institutionalAdd(@RequestBody @Valid SysDocInstitutionalAddVo vo) {
        return CommonResponse.success("制度库——新增成功", server.institutionalAdd(vo));
    }

    /**
     * 标准库——编辑
     *
     * @param vo SysDocStandardEditVo
     * @see SysDocStandardEditVo
     */
    @RequestMapping(value = "standard/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocStandardEditVo> standardEdit(@RequestBody @Valid SysDocStandardEditVo vo) {
        return CommonResponse.success("标准库——编辑成功", server.standardEdit(vo));
    }

    /**
     * 制度库——编辑
     *
     * @param vo SysDocInstitutionalEditVo
     * @see SysDocInstitutionalEditVo
     */
    @RequestMapping(value = "institutional/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocInstitutionalEditVo> institutionalEdit(@RequestBody @Valid SysDocInstitutionalEditVo vo) {
        return CommonResponse.success("制度库——编辑成功", server.institutionalEdit(vo));
    }

    /**
     * 标准库——查询
     *
     * @param param param
     * @return IPage<SysDocStandardLibEntity>
     */
    @RequestMapping(value = "standard/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SysDocStandardLibRes>> standardList(@RequestBody QueryParam param) {
        return CommonResponse.success("标准库——查询", server.standardList(param));
    }

    /**
     * 制度库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    @RequestMapping(value = "institutional/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SysDocInstitutionalLibRes>> institutionalList(@RequestBody QueryParam param) {
        return CommonResponse.success("制度库——查询", server.institutionalList(param));
    }

    /**
     * 标准库——详情
     *
     * @param id id
     * @return SysDocStandardLibEntity
     */
    @RequestMapping(value = "standard/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SysDocStandardLibRes> standardDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("标准库详情——查询", server.standardDetail(id));
    }

    /**
     * 制度库——详情
     *
     * @param id id
     * @return SysDocInstitutionalLibEntity
     */
    @RequestMapping(value = "institutional/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SysDocInstitutionalLibRes> institutionalDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("制度库详情——查询", server.institutionalDetail(id));
    }

    /**
     * 删除
     *
     * @param vo SysDocDelVo
     * @see SysDocDelVo
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody @Valid SysDocDelVo vo) {
        server.del(vo);
        return CommonResponse.success("体系文件删除成功");
    }

    /**
     * 标准库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    @RequestMapping(value = "standard/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> standardExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.standardExcelExport(ids, response);
        return CommonResponse.success("标准库——导出成功");
    }

    /**
     * 制度库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    @RequestMapping(value = "institutional/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> institutionalExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.institutionalExcelExport(ids, response);
        return CommonResponse.success("制度库——导出成功");
    }

    /**
     * oa引入
     */
    @RequestMapping(value = "oaIntroduction", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> oaIntroduction(@RequestBody String type ) {
        server.oaIntroduction(type);
        return CommonResponse.success("oa引入成功");
    }

}
