package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONUtil;
import com.beust.jcommander.internal.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 管理体系(内部控制 、 质量 、 职业健康安全 、 环境管理 、 测量 、 特种设备 、 ASME 、 标准 、 核电工程 、 核电制造)
 */
@Getter
@AllArgsConstructor
public enum ManagementSystemEnum {
    /**
     * 内部控制管理体系
     */
    NBKZ("NBKZ", "内部控制管理体系",""),
    /**
     * 质量管理体系
     */
    ZL("ZL", "质量管理体系",""),
    /**
     * 职业健康安全管理体系
     */
    ZYJKAQ("ZYJKAQ", "职业健康安全管理体系",""),
    /**
     * 环境管理管理体系
     */
    HJ("HJ", "环境管理管理体系",""),
    /**
     * 测量管理体系
     */
    CL("CL", "测量管理体系",""),
    /**
     * ASME管理体系
     */
    ASME("ASME", "ASME管理体系",""),
    /**
     * 标准管理体系
     */
    BZ("BZ", "标准管理体系",""),
    /**
     * 核电工程管理体系
     */
    HDGC("HDGC", "核电工程管理体系",""),
    /**
     * 核电制造管理体系
     */
    HDZZ("HDZZ", "核电制造管理体系",""),
    ;

    private final String managementCode;

    private final String managementName;

    private final String apiCode;

    public static final ManagementSystemEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static final List<String> CODELIST = Arrays.stream(VALUES).map(ManagementSystemEnum::getManagementCode).collect(Collectors.toList());
    public static String getNameByCode(String managementCode) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getManagementCode().equals(managementCode)) {
                return managementSystemEnum.getManagementName();
            }
        }
        return "未知";
    }
    public static String getCodeByName(String managementName) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getManagementName().equals(managementName)) {
                return managementSystemEnum.getManagementCode();
            }
        }
        return "errorCode";
    }



    /**
     * api数据转换
     */
    public static String conversionApiData(String gltx2) {
        String[] split = gltx2.split(",");
        List<String> objects = Lists.newArrayList();
        for (String apiCode : split) {
            String scopeCodeByApiCode = getScopeCodeByApiCode(apiCode);
            objects.add(scopeCodeByApiCode);
        }
        return JSONUtil.toJsonStr(objects);
    }

    public static String getScopeCodeByApiCode(String apiCode) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getApiCode().equals(apiCode)) {
                return managementSystemEnum.getManagementCode();
            }
        }
        return "errorCode";
    }
}
