package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/9/27 上午8:40
 * @Description: 经验反馈学习库
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ExpFeedbackStudyBankVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 更新着姓名
     */
    private String updateUserName;

    /**
     * 领导
     */
    private String leader;
    private String leaderName;

    /**
     * 主题
     */
    private String topic;

    /**
     * 板块
     */
    private String substance;

    /**
     * 内容
     */
    private String content;

    /**
     * 附件
     */
    private String annex;

    /**
     * 附件名称
     */
    private String annexName;

    /**
     * 入库状态
     */
    private String warehousingState;

    /**
     * 入库人
     */
    private String warehousingPersonName;

    /**
     * 入库时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date warehousingTime;

    /**
     * 单据编号
     */
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳rn回，5 提交后有人审批中
     */
    private Integer billState;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
