/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONUtil;
import com.beust.jcommander.internal.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ManagementSystemEnum {
    NBKZ("NBKZ", "\u5185\u90e8\u63a7\u5236\u7ba1\u7406\u4f53\u7cfb", ""),
    ZL("ZL", "\u8d28\u91cf\u7ba1\u7406\u4f53\u7cfb", ""),
    ZYJKAQ("ZYJKAQ", "\u804c\u4e1a\u5065\u5eb7\u5b89\u5168\u7ba1\u7406\u4f53\u7cfb", ""),
    HJ("HJ", "\u73af\u5883\u7ba1\u7406\u7ba1\u7406\u4f53\u7cfb", ""),
    CL("CL", "\u6d4b\u91cf\u7ba1\u7406\u4f53\u7cfb", ""),
    ASME("ASME", "ASME\u7ba1\u7406\u4f53\u7cfb", ""),
    BZ("BZ", "\u6807\u51c6\u7ba1\u7406\u4f53\u7cfb", ""),
    HDGC("HDGC", "\u6838\u7535\u5de5\u7a0b\u7ba1\u7406\u4f53\u7cfb", ""),
    HDZZ("HDZZ", "\u6838\u7535\u5236\u9020\u7ba1\u7406\u4f53\u7cfb", "");

    private final String managementCode;
    private final String managementName;
    private final String apiCode;
    public static final ManagementSystemEnum[] VALUES;
    public static final List<String> CODELIST;

    public static String getNameByCode(String managementCode) {
        for (ManagementSystemEnum managementSystemEnum : ManagementSystemEnum.values()) {
            if (!managementSystemEnum.getManagementCode().equals(managementCode)) continue;
            return managementSystemEnum.getManagementName();
        }
        return "\u672a\u77e5";
    }

    public static String getCodeByName(String managementName) {
        for (ManagementSystemEnum managementSystemEnum : ManagementSystemEnum.values()) {
            if (!managementSystemEnum.getManagementName().equals(managementName)) continue;
            return managementSystemEnum.getManagementCode();
        }
        return "errorCode";
    }

    public static String conversionApiData(String gltx2) {
        String[] split = gltx2.split(",");
        List objects = Lists.newArrayList();
        for (String apiCode : split) {
            String scopeCodeByApiCode = ManagementSystemEnum.getScopeCodeByApiCode(apiCode);
            objects.add(scopeCodeByApiCode);
        }
        return JSONUtil.toJsonStr((Object)objects);
    }

    public static String getScopeCodeByApiCode(String apiCode) {
        for (ManagementSystemEnum managementSystemEnum : ManagementSystemEnum.values()) {
            if (!managementSystemEnum.getApiCode().equals(apiCode)) continue;
            return managementSystemEnum.getManagementCode();
        }
        return "errorCode";
    }

    public String getManagementCode() {
        return this.managementCode;
    }

    public String getManagementName() {
        return this.managementName;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    private ManagementSystemEnum(String managementCode, String managementName, String apiCode) {
        this.managementCode = managementCode;
        this.managementName = managementName;
        this.apiCode = apiCode;
    }

    static {
        VALUES = ManagementSystemEnum.values();
        CODELIST = Arrays.stream(VALUES).map(ManagementSystemEnum::getManagementCode).collect(Collectors.toList());
    }
}

