/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ReviewReportDao;
import com.ejianc.business.quality.entity.ReviewReportEntity;
import com.ejianc.business.quality.model.vo.ReviewReportVo;
import com.ejianc.business.quality.service.ReviewReportServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReviewReportServerImpl
implements ReviewReportServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewReportServerImpl.class);
    private final ReviewReportDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewReportVo saveOrUpdate(ReviewReportVo saveOrUpdateVO) {
        ReviewReportEntity entity = (ReviewReportEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewReportEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setOrgId(userContext.getOrgId());
        entity.setOrgName(userContext.getOrgName());
        entity.setParentOrgId(userContext.getDeptId());
        entity.setParentOrgName(userContext.getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(userContext.getUserName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ReviewReportEntity)((Object)this.dao.getById(entity.getId()))).getCreateUserName());
        }
        entity.setUploadProject(userContext.getDeptName());
        entity.setUploadUserName(userContext.getUserName());
        this.dao.saveOrUpdate((Object)entity, false);
        return (ReviewReportVo)((Object)BeanMapper.map((Object)((Object)entity), ReviewReportVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<ReviewReportVo> vos) {
        try {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.dao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewReportVo detail(Long id) {
        ReviewReportEntity reviewReportEntity = (ReviewReportEntity)((Object)this.dao.selectById(id));
        return (ReviewReportVo)((Object)BeanMapper.map((Object)((Object)reviewReportEntity), ReviewReportVo.class));
    }

    @Override
    public IPage<ReviewReportVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("fileTopic", "fileName", "createUserName", "uploadProject"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewReportVo.class));
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewReportExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u62a5\u544a\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewReportServerImpl(ReviewReportDao dao, SessionManager sessionManager) {
        this.dao = dao;
        this.sessionManager = sessionManager;
    }
}

