package com.ejianc.business.quality.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InstitutionalLibraryDao;
import com.ejianc.business.quality.dao.StandardLibraryDao;
import com.ejianc.business.quality.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quality.entity.SysDocStandardLibEntity;
import com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quality.enums.ApplicableScopeEnum;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quality.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quality.model.res.OaIntroductionRes;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.BaseInfoVo;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class SystemDocumentsServerImpl implements SystemDocumentsServer {
    private static final String API_TOKEN = "6752CB5416231BA9F3D658B0252C35A97D47970DE136D07DB7F54874C846F68E";
    /**
     * 制度库
     */
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    /**
     * 标准库
     */
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;
    private final static String STANDARD_OA_URL = "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_qyebzlb_df";
    private final static String OA_TOKEN = "https://oa.ztpc.com/ssologin/getToken";


    private final SessionManager sessionManager;

    @Override
    public SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocStandardLibEntity.setOrgId(userContext.getOrgId());
            sysDocStandardLibEntity.setOrgName(userContext.getOrgName());
            sysDocStandardLibEntity.setCreateUserName(userContext.getUserName());

            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            standardLibraryDao.save(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocInstitutionalLibEntity.setOrgId(userContext.getOrgId());
            sysDocInstitutionalLibEntity.setOrgName(userContext.getOrgName());
            sysDocInstitutionalLibEntity.setCreateUserName(userContext.getUserName());

            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            institutionalLibraryDao.save(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        try {
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocStandardLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            sysDocStandardLibEntity.setCreateUserName(standardLibraryDao.getById(vo.getId()).getCreateUserName());
            standardLibraryDao.updateById(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("更新失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {

            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocInstitutionalLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            sysDocInstitutionalLibEntity.setCreateUserName(institutionalLibraryDao.getById(vo.getId()).getCreateUserName());
            institutionalLibraryDao.updateById(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibRes> standardList(QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("wjbh");
        fuzzyFields.add("wjmc");
        fuzzyFields.add("bz");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<SysDocStandardLibEntity> libEntityIpage = standardLibraryDao.queryPage(param, false);

        List<SysDocStandardLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
            BeanUtils.copyProperties(e, sysDocStandardLibRes);
            String qcr = e.getQcr();
            if (StringUtils.isNotEmpty(qcr) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
            }
            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty(bzdw) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            }
            String bzbm = e.getBzbm();
            if (StringUtils.isNotEmpty(bzbm) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
            }

            String syfw = e.getSyfw();
            if (StringUtils.isNotEmpty(syfw)) {
                sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNameByCode(syfw));
            }

            String syxmlb = e.getSyxmlb();
            if (StringUtils.isNotEmpty(syxmlb)) {
                sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNameByCode(syxmlb));
            }
            //获取OA引入的文件url地址
            if ("OA".equals(e.getOrigin())) {
                String docFileUrl = getDocFileUrl(e.getWjnr());
                sysDocStandardLibRes.setWjnr(docFileUrl);
            }
            sysDocStandardLibRes.setBzdw1(e.getBzdw());
            sysDocStandardLibRes.setBzbm1(e.getBzbm());
            sysDocStandardLibRes.setQcr1(e.getQcr());
            objects.add(sysDocStandardLibRes);
        });
        Page<SysDocStandardLibRes> page = new Page<>(libEntityIpage.getCurrent(),
                libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }


    @Override
    public IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bzbm");
        fuzzyFields.add("bzdw");
        fuzzyFields.add("zdbt");
        fuzzyFields.add("fwh");
        fuzzyFields.add("zdbm");
        fuzzyFields.add("fbrq");
        fuzzyFields.add("syjg");
        fuzzyFields.add("spjg");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<SysDocInstitutionalLibEntity> libEntityIpage = institutionalLibraryDao.queryPage(param, false);


        List<SysDocInstitutionalLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
            BeanUtils.copyProperties(e, docInstitutionalLibRes);

            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            }
            String bzbm = e.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
            }
            objects.add(docInstitutionalLibRes);
        });
        Page<SysDocInstitutionalLibRes> page = new Page<>(libEntityIpage.getCurrent(),
                libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public SysDocStandardLibRes standardDetail(Long id) {
        SysDocStandardLibEntity sysDocStandardLibEntity = standardLibraryDao.getById(id);

        SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
        BeanUtils.copyProperties(sysDocStandardLibEntity, sysDocStandardLibRes);
        String qcr = sysDocStandardLibEntity.getQcr();
        String origin = sysDocStandardLibEntity.getOrigin();
        if (StringUtils.isNotEmpty(qcr) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
        }
        String bzdw = sysDocStandardLibEntity.getBzdw();
        if (StringUtils.isNotEmpty(bzdw) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        }
        String bzbm = sysDocStandardLibEntity.getBzbm();
        if (StringUtils.isNotEmpty(bzbm) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        }

        String syfw = sysDocStandardLibEntity.getSyfw();
        sysDocStandardLibRes.setSyfw(JSONObject.parseArray(syfw, String.class));
        if (StringUtils.isNotEmpty(syfw)) {
            sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNameByCode(syfw));
        }

        String syxmlb = sysDocStandardLibEntity.getSyxmlb();
        sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray(syxmlb, String.class));
        if (StringUtils.isNotEmpty(syxmlb)) {
            sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNameByCode(syxmlb));
        }
        //获取OA引入的文件url地址
        if ("OA".equals(origin)) {
            String docFileUrl = getDocFileUrl(sysDocStandardLibEntity.getWjnr());
            sysDocStandardLibRes.setWjnr(docFileUrl);
        }
        sysDocStandardLibRes.setBzdw1(sysDocStandardLibEntity.getBzdw());
        sysDocStandardLibRes.setBzbm1(sysDocStandardLibEntity.getBzbm());
        sysDocStandardLibRes.setQcr1(sysDocStandardLibEntity.getQcr());
        return sysDocStandardLibRes;
    }

    @Override
    public SysDocInstitutionalLibRes institutionalDetail(Long id) {
        SysDocInstitutionalLibEntity byId = institutionalLibraryDao.getById(id);

        SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
        BeanUtils.copyProperties(byId, docInstitutionalLibRes);
        String bzdw = byId.getBzdw();
        if (StringUtils.isNotEmpty(bzdw)) {
            docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        }
        String bzbm = byId.getBzbm();
        if (StringUtils.isNotEmpty(bzbm)) {
            docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        }
        return docInstitutionalLibRes;
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("文件库类型不存在:【标准库STANDARD/制度库INSTITUTIONAL】");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                standardLibraryDao.removeByIds(vo.getIds());
            }
        } catch (Exception e) {
            throw new BusinessException("体系文件删除失败：" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocStandardLibEntity> list = standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String syxmlb = ApplicableProjectCategoriesEnum.getNameByCode(item.getSyxmlb());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            String syfw = ApplicableScopeEnum.getNameByCode(item.getSyfw());


            item.setType(type);
            item.setSyxmlb(syxmlb);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setSyfw(syfw);

            String qcr = item.getQcr();
            if (StringUtils.isNotEmpty(qcr)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(qcr, BaseInfoVo.class);
                item.setQcr(baseInfoVo.getName());
            }
            String bzdw = item.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzdw, BaseInfoVo.class);
                item.setBzdw(baseInfoVo.getName());
            }
            String bzbm = item.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzbm, BaseInfoVo.class);
                item.setBzbm(baseInfoVo.getName());
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("标准库体系文件导出失败：" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocInstitutionalLibEntity> list = institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            item.setType(typeName);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setBzdw(JSONObject.parseObject(item.getBzdw(), BaseInfoVo.class).getName());
            item.setBzbm(JSONObject.parseObject(item.getBzbm(), BaseInfoVo.class).getName());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("制度库体系文件导出失败：" + e.getMessage());
        }
    }

    @SneakyThrows
    @Override
    public void oaIntroduction(String type) {
        RestTemplate restTemplate = new RestTemplate();
        //header
        HttpEntity<String> requestEntity = getRequestEntity();

        ResponseEntity<OaIntroductionRes> exchange = restTemplate.exchange(STANDARD_OA_URL, HttpMethod.POST, requestEntity, OaIntroductionRes.class);
        OaIntroductionRes body = exchange.getBody();

        if (Objects.isNull(body)) {
            return;
        }
        if (!body.getSuccess()) {
            return;
        }
        List<OaIntroductionRes.DataDTO> data = body.getData();
        List<SysDocStandardLibEntity> entities = new ArrayList<>();

        if (CollUtil.isNotEmpty(data)) {
            for (OaIntroductionRes.DataDTO dto : data.stream().filter(e -> StrUtil.isNotBlank(e.getGzgltx())).collect(Collectors.toList())) {
                SysDocStandardLibEntity entity = new SysDocStandardLibEntity();

                entity.setCreateUserCode(String.valueOf(dto.getModedatacreater()));
                entity.setCreateTime(DateUtil.parseDateTime(StrUtil.join(" ", dto.getModedatacreatedate(), dto.getModedatacreatetime())));
                entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
                entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
                entity.setWjbh(dto.getWdbh());
                entity.setWjmc(dto.getWdmc());
                entity.setWjnr(dto.getQybzfj());
                String syxmlb2 = dto.getSyxmlb2();
                if (StringUtils.isNotBlank(syxmlb2)) {
                    entity.setSyxmlb(ApplicableProjectCategoriesEnum.conversionApiData(syxmlb2));
                }
                String syfw = dto.getSyfw2();
                if (StringUtils.isNotBlank(syfw)) {
                    entity.setSyfw(ApplicableScopeEnum.conversionApiData(syfw));
                }

                Integer zt = dto.getZt();
                if (Objects.nonNull(zt)) {
                    entity.setZt(SystemDocumentsStatusEnum.getCodeByApiCode(zt));
                }
                entity.setBz(String.valueOf(dto.getBz()));
                if (Objects.nonNull(dto.getFbrq())) {
                    entity.setFbrq(DateUtil.parse(dto.getFbrq(), "yyyy-MM-dd").toSqlDate());
                }
                if (Objects.nonNull(dto.getSsrq())) {
                    entity.setSsrq(DateUtil.parse(dto.getSsrq(), "yyyy-MM-dd").toSqlDate());
                }
                entity.setBzbm("OA推送");
                entity.setBzdw("OA推送");
                entity.setBm(dto.getWdbh());
                if (Objects.nonNull(dto.getFssjs())) {
                    entity.setFssj(DateUtil.parse(dto.getFssjs(), "yyyy-MM-dd").toSqlDate());
                }
                entity.setTdxx(dto.getTdxx());
                entity.setGkdw("OA推送");
                entity.setBb(String.valueOf(dto.getBb()));

                entity.setQcr("系统");

                String gltx = dto.getGzgltx();
                if (StringUtils.isNotBlank(gltx)) {
                    String[] split = gltx.split(",");
                    if (split.length > 1) {
                        for (String s : split) {
                            SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
                            BeanUtils.copyProperties(entity, sysDocStandardLibEntity);
                            sysDocStandardLibEntity.setGltx(ManagementSystemEnum.getScopeCodeByApiCode(s));
                            entities.add(sysDocStandardLibEntity);
                        }
                    } else {
                        entity.setGltx(ManagementSystemEnum.getScopeCodeByApiCode(gltx));
                        entities.add(entity);
                    }
                }
            }
        }

        // 用于存储已存在的 ID
        Set<Long> existingIds = new HashSet<>();


        // 检查数据库中已存在的 ID
        for (SysDocStandardLibEntity entity : entities) {
            long newId;
            do {
                newId = generateUniqueId();
            } while (!existingIds.add(newId));
            entity.setId(newId);
        }

        // 批量保存
        standardLibraryDao.saveBatch(entities);

    }

    private long generateUniqueId() {
        return UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
    }

    private HttpEntity<String> getRequestEntity() {
        //请求头
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("API-TOKEN", API_TOKEN);

        // 创建请求体
        Map<String, Object> map = new HashMap<>();
        map.put("pageNo", 1);
        map.put("pageSize", 99999);

        // 将 Map 转换为 JSON 字符串
        String jsonBody = JSONObject.toJSONString(map);

        // 返回 HttpEntity
        return new HttpEntity<>(jsonBody, headers);
    }

    private String getDocFileUrl(String fileId) {
        String oaToken = getOaToken();
        //https://oa.ztpc.com/spa/document/index.jsp?id=文档ID&router=1&ssoToken=token编码#/main/document/detail
        return "https://oa.ztpc.com/spa/document/index.jsp?id=" + oaToken + "&router=1&ssoToken=" + fileId + "#/main/document/detail";
    }

    private String getOaToken() {
        RestTemplate restTemplate = new RestTemplate();
        //请求头
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        // 创建 MultiValueMap 作为请求体
        MultiValueMap<String, String> body = new LinkedMultiValueMap<>();
        body.add("appid", "b5db6599-3bb1-43b2-a2c2-d4eaf8f93d26");
        body.add("loginid", "816050");


        ResponseEntity<String> exchange = restTemplate.exchange(OA_TOKEN, HttpMethod.POST, new HttpEntity<>(body, headers), String.class);
        return exchange.getBody();
    }
}
