package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @Author: LCL
 * @Date: 2024/7/23 下午3:05
 * @Description: 下达单位设置详情
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_release_unit_settings_detail")
public class ReleaseUnitSettingsDetailEntity extends BaseEntity {
    /**
     * 下达单位设置id
     */
    @TableField(value = "setting_id")
    private Long settingId;

    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    @TableField(value = "type")
    private String type;

    /**
     * 下达单位
     */
    @TableField(value = "release_units")
    private Long releaseUnits;
    @TableField(value = "release_units_name")
    private String releaseUnitsName;

    /**
     * 负责人
     */
    @TableField(value = "charge")
    private String charge;
    @TableField(value = "charge_name")
    private String chargeName;

    /**
     * 领导
     */
    @TableField(value = "leader")
    private String leader;
    @TableField(value = "leader_name")
    private String leaderName;
}
