/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InstitutionalLibraryDao;
import com.ejianc.business.quality.dao.StandardLibraryDao;
import com.ejianc.business.quality.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quality.entity.SysDocStandardLibEntity;
import com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quality.enums.ApplicableScopeEnum;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quality.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quality.model.res.OaIntroductionRes;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.BaseInfoVo;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SystemDocumentsServerImpl
implements SystemDocumentsServer {
    private static final Logger log = LoggerFactory.getLogger(SystemDocumentsServerImpl.class);
    private static final String API_TOKEN = "6752CB5416231BA9F3D658B0252C35A97D47970DE136D07DB7F54874C846F68E";
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;
    private static final String STANDARD_OA_URL = "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_qyebzlb_df";
    private static final String OA_TOKEN = "https://oa.ztpc.com/ssologin/getToken";
    private final SessionManager sessionManager;

    @Override
    public SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocStandardLibEntity));
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            sysDocStandardLibEntity.setOrgId(userContext.getOrgId());
            sysDocStandardLibEntity.setOrgName(userContext.getOrgName());
            sysDocStandardLibEntity.setCreateUserName(userContext.getUserName());
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString((Object)vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            this.standardLibraryDao.save((Object)sysDocStandardLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocInstitutionalLibEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            sysDocInstitutionalLibEntity.setOrgId(userContext.getOrgId());
            sysDocInstitutionalLibEntity.setOrgName(userContext.getOrgName());
            sysDocInstitutionalLibEntity.setCreateUserName(userContext.getUserName());
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            this.institutionalLibraryDao.save((Object)sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocInstitutionalLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocStandardLibEntity));
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        try {
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString((Object)vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            sysDocStandardLibEntity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            sysDocStandardLibEntity.setCreateUserName(((SysDocStandardLibEntity)((Object)this.standardLibraryDao.getById(vo.getId()))).getCreateUserName());
            this.standardLibraryDao.updateById((Object)sysDocStandardLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocInstitutionalLibEntity));
        try {
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            sysDocInstitutionalLibEntity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            sysDocInstitutionalLibEntity.setCreateUserName(((SysDocInstitutionalLibEntity)((Object)this.institutionalLibraryDao.getById(vo.getId()))).getCreateUserName());
            this.institutionalLibraryDao.updateById((Object)sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocInstitutionalLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibRes> standardList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("wjbh");
        fuzzyFields.add("wjmc");
        fuzzyFields.add("bz");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage libEntityIpage = this.standardLibraryDao.queryPage(param, false);
        List objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            String bzbm;
            String bzdw;
            SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
            BeanUtils.copyProperties((Object)e, (Object)((Object)sysDocStandardLibRes));
            String qcr = e.getQcr();
            if (StringUtils.isNotEmpty((CharSequence)qcr) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setQcr((BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class));
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzdw = e.getBzdw())) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzbm = e.getBzbm())) && !"OA".equals(e.getOrigin())) {
                sysDocStandardLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
            }
            String syfw = e.getSyfw();
            sysDocStandardLibRes.setSyfw(JSONObject.parseArray((String)syfw, String.class));
            if (StringUtils.isNotEmpty((CharSequence)syfw)) {
                sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNameByCode(syfw));
            }
            String syxmlb = e.getSyxmlb();
            sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray((String)syxmlb, String.class));
            if (StringUtils.isNotEmpty((CharSequence)syxmlb)) {
                sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNameByCode(syxmlb));
            }
            sysDocStandardLibRes.setBzdw1(e.getBzdw());
            sysDocStandardLibRes.setBzbm1(e.getBzbm());
            sysDocStandardLibRes.setQcr1(e.getQcr());
            objects.add(sysDocStandardLibRes);
        });
        Page page = new Page(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bzbm");
        fuzzyFields.add("bzdw");
        fuzzyFields.add("zdbt");
        fuzzyFields.add("fwh");
        fuzzyFields.add("zdbm");
        fuzzyFields.add("fbrq");
        fuzzyFields.add("syjg");
        fuzzyFields.add("spjg");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage libEntityIpage = this.institutionalLibraryDao.queryPage(param, false);
        List objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            String bzbm;
            SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
            BeanUtils.copyProperties((Object)e, (Object)((Object)docInstitutionalLibRes));
            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty((CharSequence)bzdw)) {
                docInstitutionalLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzbm = e.getBzbm()))) {
                docInstitutionalLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
            }
            objects.add(docInstitutionalLibRes);
        });
        Page page = new Page(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public SysDocStandardLibRes standardDetail(Long id) {
        String bzbm;
        String bzdw;
        SysDocStandardLibEntity sysDocStandardLibEntity = (SysDocStandardLibEntity)((Object)this.standardLibraryDao.getById(id));
        SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
        BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)sysDocStandardLibRes));
        String qcr = sysDocStandardLibEntity.getQcr();
        String origin = sysDocStandardLibEntity.getOrigin();
        if (StringUtils.isNotEmpty((CharSequence)qcr) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setQcr((BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bzdw = sysDocStandardLibEntity.getBzdw())) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bzbm = sysDocStandardLibEntity.getBzbm())) && !"OA".equals(origin)) {
            sysDocStandardLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
        }
        String syfw = sysDocStandardLibEntity.getSyfw();
        sysDocStandardLibRes.setSyfw(JSONObject.parseArray((String)syfw, String.class));
        if (StringUtils.isNotEmpty((CharSequence)syfw)) {
            sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNameByCode(syfw));
        }
        String syxmlb = sysDocStandardLibEntity.getSyxmlb();
        sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray((String)syxmlb, String.class));
        if (StringUtils.isNotEmpty((CharSequence)syxmlb)) {
            sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNameByCode(syxmlb));
        }
        if ("OA".equals(origin)) {
            String docFileUrl = this.getDocFileUrl(sysDocStandardLibEntity.getWjnr());
            sysDocStandardLibRes.setWjnr(docFileUrl);
        }
        sysDocStandardLibRes.setBzdw1(sysDocStandardLibEntity.getBzdw());
        sysDocStandardLibRes.setBzbm1(sysDocStandardLibEntity.getBzbm());
        sysDocStandardLibRes.setQcr1(sysDocStandardLibEntity.getQcr());
        return sysDocStandardLibRes;
    }

    @Override
    public SysDocInstitutionalLibRes institutionalDetail(Long id) {
        String bzbm;
        SysDocInstitutionalLibEntity byId = (SysDocInstitutionalLibEntity)((Object)this.institutionalLibraryDao.getById(id));
        SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)docInstitutionalLibRes));
        String bzdw = byId.getBzdw();
        if (StringUtils.isNotEmpty((CharSequence)bzdw)) {
            docInstitutionalLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bzbm = byId.getBzbm()))) {
            docInstitutionalLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
        }
        return docInstitutionalLibRes;
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("\u6587\u4ef6\u5e93\u7c7b\u578b\u4e0d\u5b58\u5728:\u3010\u6807\u51c6\u5e93STANDARD/\u5236\u5ea6\u5e93INSTITUTIONAL\u3011");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                this.institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                this.standardLibraryDao.removeByIds(vo.getIds());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f53\u7cfb\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String bzbm;
            String bzdw;
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String syxmlb = ApplicableProjectCategoriesEnum.getNameByCode(item.getSyxmlb());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            String syfw = ApplicableScopeEnum.getNameByCode(item.getSyfw());
            item.setType(type);
            item.setSyxmlb(syxmlb);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setSyfw(syfw);
            String qcr = item.getQcr();
            if (StringUtils.isNotEmpty((CharSequence)qcr)) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class);
                item.setQcr(baseInfoVo.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzdw = item.getBzdw()))) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class);
                item.setBzdw(baseInfoVo.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzbm = item.getBzbm()))) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class);
                item.setBzbm(baseInfoVo.getName());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u6807\u51c6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            item.setType(typeName);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setBzdw(((BaseInfoVo)JSONObject.parseObject((String)item.getBzdw(), BaseInfoVo.class)).getName());
            item.setBzbm(((BaseInfoVo)JSONObject.parseObject((String)item.getBzbm(), BaseInfoVo.class)).getName());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5236\u5ea6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void oaIntroduction(String type) {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity<String> requestEntity = this.getRequestEntity();
        ResponseEntity exchange = restTemplate.exchange(STANDARD_OA_URL, HttpMethod.POST, requestEntity, OaIntroductionRes.class, new Object[0]);
        OaIntroductionRes body = (OaIntroductionRes)exchange.getBody();
        if (Objects.isNull(body)) {
            return;
        }
        if (!body.getSuccess().booleanValue()) {
            return;
        }
        List<OaIntroductionRes.DataDTO> data = body.getData();
        ArrayList<SysDocStandardLibEntity> entities = new ArrayList<SysDocStandardLibEntity>();
        if (CollUtil.isNotEmpty(data)) {
            for (OaIntroductionRes.DataDTO dto : data.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getGzgltx())).collect(Collectors.toList())) {
                Integer zt;
                String syfw;
                SysDocStandardLibEntity entity = new SysDocStandardLibEntity();
                entity.setCreateUserCode(String.valueOf(dto.getModedatacreater()));
                entity.setCreateTime((Date)DateUtil.parseDateTime((String)StrUtil.join((CharSequence)" ", (Object[])new Object[]{dto.getModedatacreatedate(), dto.getModedatacreatetime()})));
                entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
                entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
                entity.setWjbh(dto.getWdbh());
                entity.setWjmc(dto.getWdmc());
                entity.setWjnr(dto.getQybzfj());
                String syxmlb2 = dto.getSyxmlb2();
                if (StringUtils.isNotBlank((CharSequence)syxmlb2)) {
                    entity.setSyxmlb(ApplicableProjectCategoriesEnum.conversionApiData(syxmlb2));
                }
                if (StringUtils.isNotBlank((CharSequence)(syfw = dto.getSyfw2()))) {
                    entity.setSyfw(ApplicableScopeEnum.conversionApiData(syfw));
                }
                if (Objects.nonNull(zt = dto.getZt())) {
                    entity.setZt(SystemDocumentsStatusEnum.getCodeByApiCode(zt));
                }
                entity.setBz(String.valueOf(dto.getBz()));
                if (Objects.nonNull(dto.getFbrq())) {
                    entity.setFbrq(DateUtil.parse((String)dto.getFbrq(), (String)"yyyy-MM-dd").toSqlDate());
                }
                if (Objects.nonNull(dto.getSsrq())) {
                    entity.setSsrq(DateUtil.parse((String)dto.getSsrq(), (String)"yyyy-MM-dd").toSqlDate());
                }
                entity.setBzbm("OA\u63a8\u9001");
                entity.setBzdw("OA\u63a8\u9001");
                entity.setBm(dto.getWdbh());
                if (Objects.nonNull(dto.getFssjs())) {
                    entity.setFssj(DateUtil.parse((String)dto.getFssjs(), (String)"yyyy-MM-dd").toSqlDate());
                }
                entity.setTdxx(dto.getTdxx());
                entity.setGkdw("OA\u63a8\u9001");
                entity.setBb(String.valueOf(dto.getBb()));
                entity.setQcr("\u7cfb\u7edf");
                String gltx = dto.getGzgltx();
                if (!StringUtils.isNotBlank((CharSequence)gltx)) continue;
                String[] split = gltx.split(",");
                if (split.length > 1) {
                    for (String s : split) {
                        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
                        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)sysDocStandardLibEntity));
                        sysDocStandardLibEntity.setGltx(ManagementSystemEnum.getScopeCodeByApiCode(s));
                        entities.add(sysDocStandardLibEntity);
                    }
                    continue;
                }
                entity.setGltx(ManagementSystemEnum.getScopeCodeByApiCode(gltx));
                entities.add(entity);
            }
        }
        HashSet<Long> existingIds = new HashSet<Long>();
        for (SysDocStandardLibEntity entity : entities) {
            long newId;
            while (!existingIds.add(newId = this.generateUniqueId())) {
            }
            entity.setId(newId);
        }
        this.standardLibraryDao.saveBatch(entities);
    }

    private long generateUniqueId() {
        return UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
    }

    private HttpEntity<String> getRequestEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("API-TOKEN", API_TOKEN);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("pageNo", 1);
        map.put("pageSize", 99999);
        String jsonBody = JSONObject.toJSONString(map);
        return new HttpEntity((Object)jsonBody, (MultiValueMap)headers);
    }

    private String getDocFileUrl(String fileId) {
        String oaToken = this.getOaToken();
        return "https://oa.ztpc.com/spa/document/index.jsp?id=" + fileId + "&router=1&ssoToken=" + oaToken + "#/main/document/detail";
    }

    private String getOaToken() {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"appid", (Object)"b5db6599-3bb1-43b2-a2c2-d4eaf8f93d26");
        body.add((Object)"loginid", (Object)"816050");
        ResponseEntity exchange = restTemplate.exchange(OA_TOKEN, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
        return (String)exchange.getBody();
    }

    public SystemDocumentsServerImpl(InstitutionalLibraryDao institutionalLibraryDao, StandardLibraryDao standardLibraryDao, SessionManager sessionManager) {
        this.institutionalLibraryDao = institutionalLibraryDao;
        this.standardLibraryDao = standardLibraryDao;
        this.sessionManager = sessionManager;
    }
}

