package com.ejianc.business.quality.controller;

import com.ejianc.business.quality.service.ExcelServer;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:45
 * @Description: 统一的Excel控制层
 */
@Controller
@RequestMapping("excel")
@RequiredArgsConstructor
public class ExcelController {
    private final ExcelServer server;

    /**
     * 统一的下载Excel模板
     *
     * @param excelName excel模板名称
     * @param request   请求
     * @param response  返回
     */
    @RequestMapping(value = "downloadExcelTemplate", method = RequestMethod.POST)
    @ResponseBody
    public void downloadExcelTemplate(@RequestParam("excelName") String excelName, HttpServletRequest request,
                                      HttpServletResponse response) {
        server.downloadExcelTemplate(excelName, request, response);
    }
}
