package com.ejianc.business.quality.model.res;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/11/21 上午8:33 oa标准库api返回
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OaStandardRes {

    @JsonProperty("success")
    private Boolean success;
    @JsonProperty("errorCode")
    private Integer errorCode;
    @JsonProperty("errorInfo")
    private String errorInfo;
    @JsonProperty("data")
    private List<DataDTO> data;
    @JsonProperty("space")
    private Integer space;
    @JsonProperty("jdbcQuerySpace")
    private Integer jdbcQuerySpace;
    @JsonProperty("affectedRow")
    private Object affectedRow;
    @JsonProperty("header")
    private Object header;
    @JsonProperty("page")
    private PageDTO page;
    @JsonProperty("requestSQL")
    private Object requestSQL;
    @JsonProperty("timestamp")
    private Object timestamp;
    @JsonProperty("traceId")
    private String traceId;

    @NoArgsConstructor
    @Data
    public static class PageDTO {
        @JsonProperty("totalPage")
        private Integer totalPage;
        @JsonProperty("pageSize")
        private Integer pageSize;
        @JsonProperty("totalCount")
        private Integer totalCount;
        @JsonProperty("currentPage")
        private Integer currentPage;
    }

    @NoArgsConstructor
    @Data
    public static class DataDTO {
        @JsonProperty("id")
        private Integer id;
        @JsonProperty("requestId")
        private Object requestId;
        @JsonProperty("formmodeid")
        private Integer formmodeid;
        @JsonProperty("modedatacreater")
        private Integer modedatacreater;
        @JsonProperty("modedatacreatertype")
        private Integer modedatacreatertype;
        @JsonProperty("modedatacreatedate")
        private String modedatacreatedate;
        @JsonProperty("modedatacreatetime")
        private String modedatacreatetime;
        @JsonProperty("MODEUUID")
        private String modeuuid;
        @JsonProperty("form_biz_id")
        private String formBizId;
        @JsonProperty("wdbh")
        private String wdbh;
        @JsonProperty("wdmc")
        private String wdmc;
        @JsonProperty("tdxx")
        private String tdxx;
        @JsonProperty("ssrq")
        private String ssrq;
        @JsonProperty("bzdw")
        private String bzdw;
        @JsonProperty("bzbm")
        private String bzbm;
        @JsonProperty("txjgh")
        private String txjgh;
        @JsonProperty("bb")
        private Integer bb;
        @JsonProperty("lssjqqid")
        private Object lssjqqid;
        @JsonProperty("qybzid")
        private Object qybzid;
        @JsonProperty("sfslszd")
        private Object sfslszd;
        @JsonProperty("lssjwd")
        private Object lssjwd;
        @JsonProperty("qybzfj")
        private String qybzfj;
        @JsonProperty("fssjs")
        private String fssjs;
        @JsonProperty("modedatamodifier")
        private Integer modedatamodifier;
        @JsonProperty("modedatamodifydatetime")
        private String modedatamodifydatetime;
        @JsonProperty("bzhxfl")
        private Object bzhxfl;
        @JsonProperty("zt")
        private Integer zt;
        @JsonProperty("syfw")
        private Object syfw;
        @JsonProperty("gltx")
        private Object gltx;
        @JsonProperty("bz")
        private Object bz;
        @JsonProperty("bzzxfl")
        private Object bzzxfl;
        @JsonProperty("syxmlb")
        private Object syxmlb;
        @JsonProperty("syfw1")
        private Object syfw1;
        @JsonProperty("gkdw")
        private Object gkdw;
        @JsonProperty("bzlx")
        private Object bzlx;
        @JsonProperty("bzjb")
        private Object bzjb;
        @JsonProperty("qcr")
        private Object qcr;
        @JsonProperty("shr")
        private Object shr;
        @JsonProperty("pzr")
        private Object pzr;
        @JsonProperty("fbrq")
        private String fbrq;
        @JsonProperty("gltx2")
        private String gltx2;
        @JsonProperty("yybz")
        private Object yybz;
        @JsonProperty("byybz")
        private Object byybz;
        @JsonProperty("bsbg")
        private Object bsbg;
        @JsonProperty("bzflxl")
        private Object bzflxl;
        @JsonProperty("bzflxxl")
        private Object bzflxxl;
        @JsonProperty("syxmlb2")
        private String syxmlb2;
        @JsonProperty("syfw2")
        private String syfw2;
        @JsonProperty("gzgltx")
        private String gzgltx;
        @JsonProperty("bsbg1")
        private Object bsbg1;
    }
}
