package com.ejianc.business.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ExpFeedbackStudyBankDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackStudyBankEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackStudyBankVo;
import com.ejianc.business.quality.service.ExpFeedbackStudyBankServer;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @Author: LCL
 * @Date: 2024/9/27 上午8:42
 */
@SuppressWarnings({"SpringQualifierCopyableLombok", "SpringJavaAutowiredFieldsWarningInspection"})
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ExpFeedbackStudyBankServerImpl implements ExpFeedbackStudyBankServer {
    private final ExpFeedbackStudyBankDao studyBankDao;
    private final SessionManager sessionManager;
    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;

    @Autowired
    @Qualifier("com.ejianc.foundation.support.api.IBillCodeApi")
    private IBillCodeApi iBillCodeApi;

    @Override
    public ExpFeedbackStudyBankVo saveOrUpdate(ExpFeedbackStudyBankVo saveOrUpdateVO) {
        ExpFeedbackStudyBankEntity entity = BeanMapper.map(saveOrUpdateVO, ExpFeedbackStudyBankEntity.class);
        Long id = entity.getId();
        UserContext userContext = sessionManager.getUserContext();
        Long orgId = userContext.getOrgId();
        List<ReleaseUnitSettingsDetailEntity> list = releaseUnitSettingsDetailDao.lambdaQuery().eq(ReleaseUnitSettingsDetailEntity::getReleaseUnits, orgId).eq(BaseEntity::getDr, 0).list();
        if (CollectionUtil.isEmpty(list)) {
            throw new BusinessException("暂无本单位经验反馈下达配置，请先配置！");
        }
        List<String> leader = list.stream().map(ReleaseUnitSettingsDetailEntity::getLeader).collect(Collectors.toList());
        List<String> leaderName = list.stream().map(ReleaseUnitSettingsDetailEntity::getLeaderName).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(leader) || CollectionUtil.isEmpty(leaderName)) {
            throw new BusinessException("请先在单位配置模块配置本单位的单位领导");
        }
        String leaderStr = StrUtil.join(",", leader);
        String leaderNameStr = StrUtil.join(",", leaderName);

        if (id == null) {
            entity.setLeader(leaderStr + ",");
            entity.setLeaderName(leaderNameStr + ",");
            entity.setCreateUserName(userContext.getUserName());
            entity.setWarehousingState("未入库");
            entity.setOrgId(orgId);
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
        } else {
            entity.setLeader(leaderStr + ",");
            entity.setLeaderName(leaderNameStr + ",");
            entity.setUpdateUserName(userContext.getUserName());
        }
        studyBankDao.saveOrUpdate(entity, false);


        /*
          bill_code赋值
         */
        BillCodeParam billCodeParam = BillCodeParam.build("EXP_STUDY_BANK", InvocationInfoProxy.getTenantid(), JSONObject.parseObject(JSONObject.toJSONString(entity)));
        CommonResponse<String> billCode = iBillCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            entity.setCode(billCode.getData());
            studyBankDao.updateById(entity);
        }
        return BeanMapper.map(entity, ExpFeedbackStudyBankVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<ExpFeedbackStudyBankVo> ids) {
        try {
            List<Long> delIdes = ids.stream().map(BaseVO::getId).collect(Collectors.toList());
            studyBankDao.removeByIds(delIdes, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedbackStudyBankVo detail(Long id) {
        ExpFeedbackStudyBankEntity expFeedbackStudyBankEntity = studyBankDao.selectById(id);
        return BeanMapper.map(expFeedbackStudyBankEntity, ExpFeedbackStudyBankVo.class);
    }

    @Override
    public IPage<ExpFeedbackStudyBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "substance", "content"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ExpFeedbackStudyBankEntity> page = studyBankDao.queryPage(param, false);
        IPage<ExpFeedbackStudyBankVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpFeedbackStudyBankVo.class));

        return pageData;
    }

    @Override
    public CommonResponse<List<ExpFeedbackStudyBankVo>> enterBank(List<Long> ids) {
        List<ExpFeedbackStudyBankEntity> list = studyBankDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        list.forEach(e -> {
            e.setWarehousingState("已入库");
            e.setWarehousingPerson(sessionManager.getUserContext().getUserId());
            e.setWarehousingPersonName(sessionManager.getUserContext().getUserName());
            e.setWarehousingTime(new Date());
        });
        studyBankDao.updateBatchById(list);
        return CommonResponse.success("入库成功");
    }

    @Override
    public IPage<ExpFeedbackStudyBankVo> studyBankEnterList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "substance", "content"));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("warehousingState", new Parameter(QueryParam.EQ, "已入库"));

        IPage<ExpFeedbackStudyBankEntity> page = studyBankDao.queryPage(param, false);
        IPage<ExpFeedbackStudyBankVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpFeedbackStudyBankVo.class));

        return pageData;
    }
}
