/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.service.ExpFeedbackIssuedDetailServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ExpFeedbackIssuedDetailServerImpl
implements ExpFeedbackIssuedDetailServer {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackIssuedDetailServerImpl.class);
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;

    @Override
    public ExpFeedbackIssuedDetailVo saveOrUpdate(ExpFeedbackIssuedDetailVo saveOrUpdateVO) {
        ExperienceFeedbackIssuedDetailEntity entity = (ExperienceFeedbackIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExperienceFeedbackIssuedDetailEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
            entity.setUploadDepartmentId(userContext.getDeptId());
            entity.setUploadDepartmentName(userContext.getDeptName());
            entity.setState("\u672a\u4e0a\u62a5");
            entity.setLearnState("\u672a\u5b66\u4e60");
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ExperienceFeedbackIssuedDetailEntity)((Object)this.detailDao.getById(id))).getCreateUserName());
        }
        this.detailDao.saveOrUpdate((Object)entity, false);
        ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
        BeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)expFeedbackIssuedDetailVo));
        return expFeedbackIssuedDetailVo;
    }

    @Override
    public CommonResponse<Object> del(List<ExpFeedbackIssuedDetailVo> vos) {
        try {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.detailDao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ExpFeedbackIssuedDetailVo detail(Long id) {
        ExperienceFeedbackIssuedDetailEntity experienceFeedbackIssuedDetailEntity = (ExperienceFeedbackIssuedDetailEntity)((Object)this.detailDao.selectById(id));
        return (ExpFeedbackIssuedDetailVo)((Object)BeanMapper.map((Object)((Object)experienceFeedbackIssuedDetailEntity), ExpFeedbackIssuedDetailVo.class));
    }

    @Override
    public IPage<ExpFeedbackIssuedDetailVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName", "uploadDepartmentName"));
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (Objects.nonNull(orgId) && !orgId.equals(1502571152583692289L)) {
            param.getParams().put("uploadDepartmentId", new Parameter("eq", (Object)orgId));
        }
        IPage page = this.detailDao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpFeedbackIssuedDetailVo.class));
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("expFeedbackIssuedDetailExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ExpFeedbackIssuedDetailServerImpl(ExpFeedbackIssuedDetailDao detailDao, SessionManager sessionManager) {
        this.detailDao = detailDao;
        this.sessionManager = sessionManager;
    }
}

