package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewRefineAdviceVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 * @Description: 评审管理-改进建议
 */
public interface ReviewRefineAdviceServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ReviewRefineAdviceVo
     */
    ReviewRefineAdviceVo saveOrUpdate(ReviewRefineAdviceVo saveOrUpdateVO);

    /**
     * 详情
     *
     * @param id id
     * @return ReviewRefineAdviceVo
     */
    ReviewRefineAdviceVo detail(Long id);

    /**
     * 删除
     *
     * @param vos vos
     * @return 结果
     */
    CommonResponse<Object> del(List<ReviewRefineAdviceVo> vos);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReviewRefineAdviceVo>
     */
    IPage<ReviewRefineAdviceVo> list(QueryParam param);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response 文件
     */
    void excelExport(List<Long> ids, HttpServletResponse response);
}
