package com.ejianc.business.quality.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InstitutionalLibraryDao;
import com.ejianc.business.quality.dao.StandardLibraryDao;
import com.ejianc.business.quality.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quality.entity.SysDocStandardLibEntity;
import com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quality.enums.ApplicableScopeEnum;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quality.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quality.model.res.OaInstitutionalRes;
import com.ejianc.business.quality.model.res.OaStandardRes;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.BaseInfoVo;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
@SuppressWarnings({"AlibabaCollectionInitShouldAssignCapacity", "AlibabaUndefineMagicConstant", "deprecation"})
@Service
@Slf4j
@RequiredArgsConstructor
public class SystemDocumentsServerImpl implements SystemDocumentsServer {
    /**
     * 标准库token
     */
    private static final String STANDARD_API_TOKEN = "6752CB5416231BA9F3D658B0252C35A97D47970DE136D07DB7F54874C846F68E";
    private final static String STANDARD_OA_URL = "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_qyebzlb_df";
    /**
     * 制度库token
     */
    private static final String INSTITUTIONAL_API_TOKEN =
        "8AB60E29DBEFBAE2BB570A2C27ABA7807D47970DE136D07DB7F54874C846F68E";
    private final static String INSTITUTIONAL_OA_URL =
        "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_zdlbmkbd_df";
    /**
     * 制度库
     */
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    /**
     * 标准库
     */
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;
    private final static String OA_TOKEN = "https://oa.ztpc.com/ssologin/getToken";

    private final SessionManager sessionManager;

    @Override
    public SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        List<String> gltx = vo.getGltx();
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocStandardLibEntity.setOrgId(userContext.getOrgId());
            sysDocStandardLibEntity.setOrgName(userContext.getOrgName());
            sysDocStandardLibEntity.setCreateUserName(userContext.getUserName());

            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            standardLibraryDao.save(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        List<String> gltx = vo.getGltx();
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocInstitutionalLibEntity.setOrgId(userContext.getOrgId());
            sysDocInstitutionalLibEntity.setOrgName(userContext.getOrgName());
            sysDocInstitutionalLibEntity.setCreateUserName(userContext.getUserName());

            sysDocInstitutionalLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            institutionalLibraryDao.save(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        List<String> gltx = vo.getGltx();
        try {
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocStandardLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            sysDocStandardLibEntity.setCreateUserName(standardLibraryDao.getById(vo.getId()).getCreateUserName());
            standardLibraryDao.updateById(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("更新失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        List<String> gltx = vo.getGltx();
        try {
            sysDocInstitutionalLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocInstitutionalLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            sysDocInstitutionalLibEntity
                .setCreateUserName(institutionalLibraryDao.getById(vo.getId()).getCreateUserName());
            institutionalLibraryDao.updateById(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibRes> standardList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Parameter gltxParameter = params.getOrDefault("gltx", null);
        String gltx = Objects.isNull(gltxParameter) ? "" : String.valueOf(gltxParameter.getValue());
        Parameter type = params.getOrDefault("type", null);
        String searchText = param.getSearchText();

        IPage<SysDocStandardLibEntity> libResIpage = new Page<>(param.getPageIndex(), param.getPageSize());
        LambdaQueryChainWrapper<SysDocStandardLibEntity> sysDocStandardLibEntityLambdaQueryChainWrapper =
            standardLibraryDao.lambdaQuery()
                .eq(Objects.nonNull(type), SysDocStandardLibEntity::getType, String.valueOf(type.getValue()))
                .like(StringUtils.isNotBlank(gltx), SysDocStandardLibEntity::getGltx, gltx)
                .orderByDesc(BaseEntity::getCreateTime);

        if (StrUtil.isNotBlank(searchText)) {
            sysDocStandardLibEntityLambdaQueryChainWrapper
                .and(i -> i.like(StrUtil.isNotBlank(searchText), SysDocStandardLibEntity::getWjbh, searchText).or()
                    .like(StrUtil.isNotBlank(searchText), SysDocStandardLibEntity::getWjmc, searchText));

        }
        IPage<SysDocStandardLibEntity> libEntityIpage =
            sysDocStandardLibEntityLambdaQueryChainWrapper.page(libResIpage);

        List<SysDocStandardLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
            BeanUtils.copyProperties(e, sysDocStandardLibRes);
            String qcr = e.getQcr();
            sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
            String bzdw = e.getBzdw();
            sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            String bzbm = e.getBzbm();
            sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));

            String syfw = e.getSyfw();
            sysDocStandardLibRes.setSyfw(JSONObject.parseArray(syfw, String.class));
            if (StringUtils.isNotEmpty(syfw)) {
                sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNamesByCodes(syfw));
            }

            String syxmlb = e.getSyxmlb();
            sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray(syxmlb, String.class));
            if (StringUtils.isNotEmpty(syxmlb)) {
                sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
            }

            String gltx1 = e.getGltx();
            sysDocStandardLibRes.setGltx(JSONObject.parseArray(gltx1, String.class));
            if (StringUtils.isNotEmpty(gltx1)) {
                sysDocStandardLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx1));
            }
            sysDocStandardLibRes.setBzdw1(e.getBzdw());
            sysDocStandardLibRes.setBzbm1(e.getBzbm());
            sysDocStandardLibRes.setQcr1(e.getQcr());
            objects.add(sysDocStandardLibRes);
        });
        Page<SysDocStandardLibRes> page =
            new Page<>(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Parameter gltxParameter = params.getOrDefault("gltx", null);
        String gltx = Objects.isNull(gltxParameter) ? "" : String.valueOf(gltxParameter.getValue());
        Parameter type = params.getOrDefault("type", null);
        String searchText = param.getSearchText();

        IPage<SysDocInstitutionalLibEntity> libResIpage = new Page<>(param.getPageIndex(), param.getPageSize());
        LambdaQueryChainWrapper<SysDocInstitutionalLibEntity> sysDocInstitutionalLibEntityLambdaQueryChainWrapper =
            institutionalLibraryDao.lambdaQuery().eq(BaseEntity::getDr, 0L)
                .eq(Objects.nonNull(type), SysDocInstitutionalLibEntity::getType, String.valueOf(type.getValue()))
                .like(StringUtils.isNotBlank(gltx), SysDocInstitutionalLibEntity::getGltx, gltx)
                .orderByDesc(BaseEntity::getCreateTime);
        if (StrUtil.isNotBlank(searchText)) {
            sysDocInstitutionalLibEntityLambdaQueryChainWrapper
                .and(i -> i.like(StrUtil.isNotBlank(searchText), SysDocInstitutionalLibEntity::getZdbt, searchText).or()
                    .like(StrUtil.isNotBlank(searchText), SysDocInstitutionalLibEntity::getZdbm, searchText));
        }
        IPage<SysDocInstitutionalLibEntity> libEntityIpage =
            sysDocInstitutionalLibEntityLambdaQueryChainWrapper.page(libResIpage);

        List<SysDocInstitutionalLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
            BeanUtils.copyProperties(e, docInstitutionalLibRes);

            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            }
            String bzbm = e.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
            }

            String gltx1 = e.getGltx();
            docInstitutionalLibRes.setGltx(JSONObject.parseArray(gltx1, String.class));
            if (StringUtils.isNotEmpty(gltx1)) {
                docInstitutionalLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx1));
            }
            objects.add(docInstitutionalLibRes);
        });
        Page<SysDocInstitutionalLibRes> page =
            new Page<>(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public SysDocStandardLibRes standardDetail(Long id) {
        SysDocStandardLibEntity sysDocStandardLibEntity = standardLibraryDao.getById(id);

        SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
        BeanUtils.copyProperties(sysDocStandardLibEntity, sysDocStandardLibRes);
        String qcr = sysDocStandardLibEntity.getQcr();
        String origin = sysDocStandardLibEntity.getOrigin();
        sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
        sysDocStandardLibRes.setQcr1(sysDocStandardLibEntity.getQcr());

        String bzdw = sysDocStandardLibEntity.getBzdw();
        sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        sysDocStandardLibRes.setBzdw1(sysDocStandardLibEntity.getBzdw());
        String bzbm = sysDocStandardLibEntity.getBzbm();
        sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        sysDocStandardLibRes.setBzbm1(sysDocStandardLibEntity.getBzbm());

        String syfw = sysDocStandardLibEntity.getSyfw();
        if (StringUtils.isNotEmpty(syfw)) {
            sysDocStandardLibRes.setSyfw(JSONObject.parseArray(syfw, String.class));
            sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNamesByCodes(syfw));
        } else {
            sysDocStandardLibRes.setSyfw(Lists.newArrayList());
            sysDocStandardLibRes.setSyfw1("");
        }

        String syxmlb = sysDocStandardLibEntity.getSyxmlb();
        if (StringUtils.isNotEmpty(syxmlb)) {
            sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray(syxmlb, String.class));
            sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
        } else {
            sysDocStandardLibRes.setSyxmlb(Lists.newArrayList());
            sysDocStandardLibRes.setSyxmlb1("");
        }

        String gltx = sysDocStandardLibEntity.getGltx();
        if (StringUtils.isNotEmpty(gltx)) {
            sysDocStandardLibRes.setGltx(JSONObject.parseArray(gltx, String.class));
            sysDocStandardLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx));
        } else {
            sysDocStandardLibRes.setGltx(Lists.newArrayList());
            sysDocStandardLibRes.setGltx1("");
        }
        // 获取OA引入的文件url地址
        if ("OA".equals(origin)) {
            String docFileUrl = getDocFileUrl(sysDocStandardLibEntity.getWjnr());
            sysDocStandardLibRes.setWjnr(docFileUrl);
        }
        return sysDocStandardLibRes;
    }

    @Override
    public SysDocInstitutionalLibRes institutionalDetail(Long id) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = institutionalLibraryDao.getById(id);

        SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
        BeanUtils.copyProperties(sysDocInstitutionalLibEntity, docInstitutionalLibRes);
        String bzdw = sysDocInstitutionalLibEntity.getBzdw();
        if (StringUtils.isNotEmpty(bzdw)) {
            docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        }
        String bzbm = sysDocInstitutionalLibEntity.getBzbm();
        if (StringUtils.isNotEmpty(bzbm)) {
            docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        }

        String gltx = sysDocInstitutionalLibEntity.getGltx();
        if (StringUtils.isNotEmpty(gltx)) {
            docInstitutionalLibRes.setGltx(JSONObject.parseArray(gltx, String.class));
            docInstitutionalLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx));
        } else {
            docInstitutionalLibRes.setGltx(Lists.newArrayList());
            docInstitutionalLibRes.setGltx1("");
        }
        // 获取OA引入的文件url地址
        if ("OA".equals(sysDocInstitutionalLibEntity.getOrigin())) {
            String docFileUrl = getDocFileUrl(sysDocInstitutionalLibEntity.getZdzw());
            docInstitutionalLibRes.setZdzw(docFileUrl);
        }
        return docInstitutionalLibRes;
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("文件库类型不存在:【标准库STANDARD/制度库INSTITUTIONAL】");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                standardLibraryDao.removeByIds(vo.getIds());
            }
        } catch (Exception e) {
            throw new BusinessException("体系文件删除失败：" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocStandardLibEntity> list = standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        // 导出展示类别中文处理
        list.forEach(item -> {
            String type = item.getType();
            if (StringUtils.isNotEmpty(type)) {
                item.setType(QualityTypeEnum.getNameByCode(type));
            }
            String syfw = item.getSyfw();
            if (StringUtils.isNotEmpty(syfw)) {
                item.setSyfw(ApplicableScopeEnum.getNamesByCodes(syfw));
            }
            String gltx = item.getGltx();
            if (StringUtils.isNotEmpty(gltx)) {
                item.setGltx(ManagementSystemEnum.getNamesByCodes(gltx));
            }
            String zt = item.getZt();
            if (StringUtils.isNotEmpty(zt)) {
                item.setZt(SystemDocumentsStatusEnum.getNameByCode(zt));
            }
            String syxmlb = item.getSyxmlb();
            if (StringUtils.isNotEmpty(syxmlb)) {
                item.setSyxmlb(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
            }

            String qcr = item.getQcr();
            if (StringUtils.isNotEmpty(qcr)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(qcr, BaseInfoVo.class);
                item.setQcr(baseInfoVo.getName());
            }
            String bzdw = item.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzdw, BaseInfoVo.class);
                item.setBzdw(baseInfoVo.getName());
            }
            String bzbm = item.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzbm, BaseInfoVo.class);
                item.setBzbm(baseInfoVo.getName());
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("标准库体系文件导出失败：" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocInstitutionalLibEntity> list =
            institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        // 导出展示类别中文处理
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = item.getGltx();
            if (StringUtils.isNotEmpty(gltx)) {
                item.setGltx(ManagementSystemEnum.getNamesByCodes(gltx));
            }
            item.setType(typeName);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setBzdw(JSONObject.parseObject(item.getBzdw(), BaseInfoVo.class).getName());
            item.setBzbm(JSONObject.parseObject(item.getBzbm(), BaseInfoVo.class).getName());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("制度库体系文件导出失败：" + e.getMessage());
        }
    }

    /**
     * OA标准库定时任务
     */
    @Override
    public void oaStandardScheduled() {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity<String> requestEntity = getRequestEntity(STANDARD_API_TOKEN);

        ResponseEntity<OaStandardRes> exchange =
            restTemplate.exchange(STANDARD_OA_URL, HttpMethod.POST, requestEntity, OaStandardRes.class);
        OaStandardRes body = exchange.getBody();

        if (Objects.isNull(body) || !body.getSuccess()) {
            throw new BusinessException("标准引入失败，原因：" + (body != null ? body.getErrorInfo() : "标准引入失败：" + body));
        }

        List<OaStandardRes.DataDTO> data = body.getData();
        List<SysDocStandardLibEntity> entities = new ArrayList<>();

        if (CollUtil.isEmpty(data)) {
            return;
        }

        List<SysDocStandardLibEntity> oaList = standardLibraryDao.lambdaQuery().eq(BaseEntity::getDr, 0L)
            .eq(SysDocStandardLibEntity::getOrigin, "OA").list();
        Map<String, Map<String, SysDocStandardLibEntity>> wjnrUpdateTimeMap =
            oaList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SysDocStandardLibEntity::getWjnr,
                Collectors.toMap(e -> DateUtil.format(e.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"), Function.identity())));

        List<OaStandardRes.DataDTO> collect =
            data.stream().filter(e -> StrUtil.isNotBlank(e.getGzgltx())).collect(Collectors.toList());

        for (OaStandardRes.DataDTO dto : collect) {
            processDataDTO(dto, wjnrUpdateTimeMap, entities);
        }

        // 批量保存
        if (CollUtil.isNotEmpty(entities)) {
            // 用于存储已存在的 ID
            Set<Long> existingIds = new HashSet<>();

            // 从 oaList 中提取所有实体的 ID
            List<Long> collect1 = oaList.stream().map(BaseEntity::getId).collect(Collectors.toList());

            // 检查数据库中已存在的 ID
            for (SysDocStandardLibEntity entity : entities.stream().filter(e -> Objects.isNull(e.getId()))
                .collect(Collectors.toSet())) {
                long newId;
                do {
                    newId = generateUniqueId();
                } while (!existingIds.add(newId) || collect1.contains(newId));

                entity.setId(newId);
            }

            standardLibraryDao.saveOrUpdateBatch(entities);
        }
    }

    private void processDataDTO(OaStandardRes.DataDTO dto,
        Map<String, Map<String, SysDocStandardLibEntity>> wjnrUpdateTimeMap, List<SysDocStandardLibEntity> entities) {
        String wjnr = dto.getQybzfj();
        String modedatamodifydatetime = dto.getModedatamodifydatetime();

        if (wjnrUpdateTimeMap.containsKey(wjnr)) {
            Map<String, SysDocStandardLibEntity> dateSysDocStandardLibEntityMap = wjnrUpdateTimeMap.get(wjnr);
            if (dateSysDocStandardLibEntityMap.containsKey(modedatamodifydatetime)) {
                return;
            }
            dateSysDocStandardLibEntityMap.values().forEach(
                sysDocStandardLibEntity -> entities.add(createEntityFromDTO(dto, sysDocStandardLibEntity.getId())));
        } else {
            entities.add(createEntityFromDTO(dto, null));
        }
    }

    private SysDocStandardLibEntity createEntityFromDTO(OaStandardRes.DataDTO dto, Long existingId) {
        SysDocStandardLibEntity entity = new SysDocStandardLibEntity();
        if (existingId != null) {
            entity.setId(existingId);
        }
        String defaultJsonStr = createEntity(dto, entity);
        entity.setSyxmlb(getEnumValue(dto.getSyxmlb2(), ApplicableProjectCategoriesEnum::conversionApiData));
        entity.setSyfw(getEnumValue(dto.getSyfw2(), ApplicableScopeEnum::conversionApiData));
        entity.setZt(Objects.nonNull(dto.getZt()) ? SystemDocumentsStatusEnum.getCodeByApiCode(dto.getZt()) : null);
        entity.setBz(Objects.nonNull(dto.getBz()) ? String.valueOf(dto.getBz()) : null);
        entity.setFbrq(
            StrUtil.isNotBlank(dto.getFbrq()) ? DateUtil.parse(dto.getFbrq(), "yyyy-MM-dd").toSqlDate() : null);
        entity.setSsrq(
            StrUtil.isNotBlank(dto.getSsrq()) ? DateUtil.parse(dto.getSsrq(), "yyyy-MM-dd").toSqlDate() : null);
        entity.setBzbm(defaultJsonStr);
        entity.setBzdw(defaultJsonStr);
        entity.setBm(dto.getWdbh());
        entity.setFssj(
            StrUtil.isNotBlank(dto.getFssjs()) ? DateUtil.parse(dto.getFssjs(), "yyyy-MM-dd").toSqlDate() : null);
        entity.setTdxx(dto.getTdxx());
        entity.setGkdw("OA推送");
        entity.setBb(Objects.nonNull(dto.getBb()) ? String.valueOf(dto.getBb()) : null);
        entity.setQcr(defaultJsonStr);
        entity.setGltx(JSONObject.toJSONString(getGltx(dto.getGzgltx())));
        return entity;
    }

    private String createEntity(OaStandardRes.DataDTO dto, SysDocStandardLibEntity entity) {
        BaseInfoVo baseInfoVo = new BaseInfoVo();
        baseInfoVo.setId("OA推送");
        baseInfoVo.setCode("OA推送");
        baseInfoVo.setName("OA推送");
        String defaultJsonStr = JSONUtil.toJsonStr(baseInfoVo);

        entity.setCreateUserCode("OA推送");
        entity.setCreateTime(
            DateUtil.parseDateTime(StrUtil.join(" ", dto.getModedatacreatedate(), dto.getModedatacreatetime())));
        entity.setUpdateTime(DateUtil.parseDateTime(dto.getModedatamodifydatetime()));
        entity.setCreateUserName("OA推送");
        entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
        entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
        entity.setWjbh(dto.getWdbh());
        entity.setWjmc(dto.getWdmc());
        entity.setWjnr(dto.getQybzfj());
        return defaultJsonStr;
    }

    private List<String> getGltx(String gltx) {
        List<String> res = new ArrayList<>(Collections.emptyList());
        if (StringUtils.isNotBlank(gltx)) {
            String[] split = gltx.split(",");
            for (String s : split) {
                String scopeCodeByApiCode = ManagementSystemEnum.getCodeByApiCode(s);
                res.add(scopeCodeByApiCode);
            }
        }
        return res;
    }

    private <T> T getEnumValue(String value, Function<String, T> converter) {
        return StringUtils.isNotBlank(value) ? converter.apply(value) : null;
    }

    @Override
    public void oaInstitutionalScheduled() {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity<String> requestEntity = getRequestEntity(INSTITUTIONAL_API_TOKEN);

        ResponseEntity<OaInstitutionalRes> exchange =
            restTemplate.exchange(INSTITUTIONAL_OA_URL, HttpMethod.POST, requestEntity, OaInstitutionalRes.class);
        OaInstitutionalRes body = exchange.getBody();

        if (Objects.isNull(body) || !body.getSuccess()) {
            throw new BusinessException("制度库引入失败，原因：" + (body != null ? body.getErrorInfo() : "制度库引入失败：" + body));
        }

        List<OaInstitutionalRes.DataDTO> data = body.getData();
        List<SysDocInstitutionalLibEntity> entities = new ArrayList<>();

        if (CollUtil.isEmpty(data)) {
            return;
        }

        List<SysDocInstitutionalLibEntity> oaList = institutionalLibraryDao.lambdaQuery().eq(BaseEntity::getDr, 0L)
            .eq(SysDocInstitutionalLibEntity::getOrigin, "OA").list();

        Map<String, Map<String, SysDocInstitutionalLibEntity>> wjnrUpdateTimeMap = oaList.stream()
            .filter(Objects::nonNull).collect(Collectors.groupingBy(SysDocInstitutionalLibEntity::getZdzw,
                Collectors.toMap(e -> DateUtil.format(e.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"), Function.identity())));

        for (OaInstitutionalRes.DataDTO dto : data) {
            if (dto == null) {
                continue;
            }
            String zdzw = String.valueOf(dto.getZdpdfzw());// 需确认字段
            String modedatamodifydatetime = dto.getModedatamodifydatetime();

            SysDocInstitutionalLibEntity entity = createEntityFromDto(dto, zdzw, modedatamodifydatetime);
            if (wjnrUpdateTimeMap.containsKey(zdzw)
                && wjnrUpdateTimeMap.get(zdzw).containsKey(modedatamodifydatetime)) {
                continue;
            }

            if (wjnrUpdateTimeMap.containsKey(zdzw)) {
                Long id = wjnrUpdateTimeMap.get(zdzw).get(modedatamodifydatetime).getId();
                entity.setId(id);
            }

            entities.add(entity);
        }

        // 批量保存
        if (CollUtil.isNotEmpty(entities)) {
            Set<Long> existingIds = new HashSet<>();
            List<Long> collect1 = oaList.stream().map(BaseEntity::getId).collect(Collectors.toList());

            for (SysDocInstitutionalLibEntity entity : entities) {
                if (Objects.isNull(entity.getId())) {
                    long newId;
                    do {
                        newId = generateUniqueId();
                    } while (!existingIds.add(newId) || collect1.contains(newId));

                    entity.setId(newId);
                }
            }

            institutionalLibraryDao.saveOrUpdateBatch(entities);
        }
    }

    private SysDocInstitutionalLibEntity createEntityFromDto(OaInstitutionalRes.DataDTO dto, String zdzw,
        String modedatamodifydatetime) {
        BaseInfoVo baseInfoVo = new BaseInfoVo();
        baseInfoVo.setId("OA推送");
        baseInfoVo.setCode("OA推送");
        baseInfoVo.setName("OA推送");
        String defaultJsonStr = JSONUtil.toJsonStr(baseInfoVo);

        SysDocInstitutionalLibEntity entity = new SysDocInstitutionalLibEntity();
        entity.setCreateUserCode("OA推送");
        entity.setCreateTime(
            DateUtil.parseDateTime(StrUtil.join(" ", dto.getModedatacreatedate(), dto.getModedatacreatetime())));
        entity.setUpdateTime(DateUtil.parseDateTime(modedatamodifydatetime));
        entity.setCreateUserName("OA推送");
        entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
        entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
        entity.setBzbm(defaultJsonStr);
        entity.setBzdw(defaultJsonStr);
        entity.setZdbt(dto.getZdbt());
        entity.setZdzw(zdzw);
        entity.setZdbb(Objects.nonNull(dto.getZdbb()) ? String.valueOf(dto.getZdbb()) : null);
        entity.setFwh(dto.getFwh());
        entity.setZdbm(dto.getZdbh());
        String fbrq = dto.getFbrq();
        entity.setFbrq(Objects.nonNull(fbrq) ? DateUtil.parse(fbrq, "yyyy-MM-dd").toSqlDate() : null);
        entity.setSyjg(dto.getSyjg());
        entity.setSpjg(dto.getSpjg());
        // entity.setZt(dto.getYhzt());需确认枚举
        // entity.setGsbb(dto.getGsbb());需确认枚举
        // entity.setZgs(dto.getZgs());需确认枚举
        // entity.setFgs(dto.getFgs());需确认枚举
        // entity.setZgxm(dto.getZgxm()); 需确认枚举
        // entity.setGltx(getGltx(dto.getGzgltx())); 需确认字段
        entity.setBm(Objects.nonNull(dto.getBm()) ? String.valueOf(dto.getBm()) : null);

        return entity;
    }

    private long generateUniqueId() {
        return UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
    }

    private HttpEntity<String> getRequestEntity(String apiToken) {
        // 请求头
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("API-TOKEN", apiToken);

        // 创建请求体
        Map<String, Object> map = new HashMap<>();
        map.put("pageNo", 1);
        map.put("pageSize", 99999);

        // 将 Map 转换为 JSON 字符串
        String jsonBody = JSONObject.toJSONString(map);

        // 返回 HttpEntity
        return new HttpEntity<>(jsonBody, headers);
    }

    private String getDocFileUrl(String fileId) {
        String oaToken = getOaToken();
        // https://oa.ztpc.com/spa/document/index.jsp?id=文档ID&router=1&ssoToken=token编码#/main/document/detail
        return "https://oa.ztpc.com/spa/document/index.jsp?id=" + fileId + "&router=1&ssoToken=" + oaToken
            + "#/main/document/detail";
    }

    private String getOaToken() {
        RestTemplate restTemplate = new RestTemplate();
        // 请求头
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        // 创建 MultiValueMap 作为请求体
        MultiValueMap<String, String> body = new LinkedMultiValueMap<>();
        body.add("appid", "b5db6599-3bb1-43b2-a2c2-d4eaf8f93d26");
        body.add("loginid", "816050");

        ResponseEntity<String> exchange =
            restTemplate.exchange(OA_TOKEN, HttpMethod.POST, new HttpEntity<>(body, headers), String.class);
        return exchange.getBody();
    }
}
