package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
public interface SystemDocumentsServer {
    /**
     * 标准库——·
     *
     * @param vo SysDocStandardAddVo
     * @return SysDocStandardLibEntity
     * @see SysDocStandardAddVo
     */
    SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo);

    /**
     * 制度库——新增
     *
     * @param vo SysDocInstitutionalAddVo
     * @return SysDocInstitutionalLibEntity
     * @see SysDocInstitutionalAddVo
     */
    SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo);

    /**
     * 标准库——编辑
     *
     * @param vo SysDocStandardEditVo
     * @return SysDocStandardLibEntity
     * @see SysDocStandardEditVo
     */
    SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo);

    /**
     * 制度库——编辑
     *
     * @param vo SysDocInstitutionalEditVo
     * @return SysDocInstitutionalLibEntity
     * @see SysDocInstitutionalEditVo
     */
    SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo);

    /**
     * 标准库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    IPage<SysDocStandardLibRes> standardList(@Valid QueryParam param);

    /**
     * 制度库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param);

    /**
     * 标准库——详情
     *
     * @param id id
     * @return SysDocStandardLibEntity
     */
    SysDocStandardLibRes standardDetail(Long id);

    /**
     * 制度库——详情
     *
     * @param id id
     * @return SysDocInstitutionalLibEntity
     */
    SysDocInstitutionalLibRes institutionalDetail(Long id);

    /**
     * 删除
     *
     * @param vo SysDocDelVo
     * @see SysDocDelVo
     */
    void del(SysDocDelVo vo);

    /**
     * 标准库——导出
     *
     * @param ids 数据id
     * @param response 请求
     */
    void standardExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 制度库——导出
     *
     * @param ids 数据id
     * @param response 请求
     */
    void institutionalExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 标准库自动引入
     */
    void oaStandardScheduled();

    /**
     * 制度库自动引入
     */
    void oaInstitutionalScheduled();
}
