/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InstitutionalLibraryDao;
import com.ejianc.business.quality.dao.StandardLibraryDao;
import com.ejianc.business.quality.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quality.entity.SysDocStandardLibEntity;
import com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quality.enums.ApplicableScopeEnum;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quality.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quality.model.res.OaInstitutionalRes;
import com.ejianc.business.quality.model.res.OaStandardRes;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.BaseInfoVo;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SystemDocumentsServerImpl
implements SystemDocumentsServer {
    private static final Logger log = LoggerFactory.getLogger(SystemDocumentsServerImpl.class);
    private static final String STANDARD_API_TOKEN = "6752CB5416231BA9F3D658B0252C35A97D47970DE136D07DB7F54874C846F68E";
    private static final String STANDARD_OA_URL = "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_qyebzlb_df";
    private static final String INSTITUTIONAL_API_TOKEN = "8AB60E29DBEFBAE2BB570A2C27ABA7807D47970DE136D07DB7F54874C846F68E";
    private static final String INSTITUTIONAL_OA_URL = "http://10.136.208.108:81/api/gateway/ods_ztpc_oa_uf_zdlbmkbd_df";
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;
    private static final String OA_TOKEN = "https://oa.ztpc.com/ssologin/getToken";
    private final SessionManager sessionManager;

    @Override
    public SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocStandardLibEntity));
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        List<String> gltx = vo.getGltx();
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            sysDocStandardLibEntity.setOrgId(userContext.getOrgId());
            sysDocStandardLibEntity.setOrgName(userContext.getOrgName());
            sysDocStandardLibEntity.setCreateUserName(userContext.getUserName());
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString((Object)vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            this.standardLibraryDao.save((Object)sysDocStandardLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocInstitutionalLibEntity));
        List<String> gltx = vo.getGltx();
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            sysDocInstitutionalLibEntity.setOrgId(userContext.getOrgId());
            sysDocInstitutionalLibEntity.setOrgName(userContext.getOrgName());
            sysDocInstitutionalLibEntity.setCreateUserName(userContext.getUserName());
            sysDocInstitutionalLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            this.institutionalLibraryDao.save((Object)sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocInstitutionalLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocStandardLibEntity));
        List<String> syfw = vo.getSyfw();
        List<String> syxmlb = vo.getSyxmlb();
        List<String> gltx = vo.getGltx();
        try {
            sysDocStandardLibEntity.setSyxmlb(JSONObject.toJSONString(syxmlb));
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString((Object)vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            sysDocStandardLibEntity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            sysDocStandardLibEntity.setCreateUserName(((SysDocStandardLibEntity)((Object)this.standardLibraryDao.getById(vo.getId()))).getCreateUserName());
            this.standardLibraryDao.updateById((Object)sysDocStandardLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sysDocInstitutionalLibEntity));
        List<String> gltx = vo.getGltx();
        try {
            sysDocInstitutionalLibEntity.setGltx(JSONObject.toJSONString(gltx));
            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString((Object)vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString((Object)vo.getBzdw()));
            sysDocInstitutionalLibEntity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            sysDocInstitutionalLibEntity.setCreateUserName(((SysDocInstitutionalLibEntity)((Object)this.institutionalLibraryDao.getById(vo.getId()))).getCreateUserName());
            this.institutionalLibraryDao.updateById((Object)sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties((Object)((Object)sysDocInstitutionalLibEntity), (Object)((Object)vo));
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibRes> standardList(QueryParam param) {
        Map params = param.getParams();
        Parameter gltxParameter = params.getOrDefault("gltx", null);
        String gltx = Objects.isNull(gltxParameter) ? "" : String.valueOf(gltxParameter.getValue());
        Parameter type = params.getOrDefault("type", null);
        String searchText = param.getSearchText();
        Page libResIpage = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        LambdaQueryChainWrapper sysDocStandardLibEntityLambdaQueryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().eq(Objects.nonNull(type), SysDocStandardLibEntity::getType, (Object)String.valueOf(type.getValue()))).like(StringUtils.isNotBlank((CharSequence)gltx), SysDocStandardLibEntity::getGltx, (Object)gltx)).orderByDesc(BaseEntity::getCreateTime);
        if (StrUtil.isNotBlank((CharSequence)searchText)) {
            sysDocStandardLibEntityLambdaQueryChainWrapper.and(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(StrUtil.isNotBlank((CharSequence)searchText), SysDocStandardLibEntity::getWjbh, (Object)searchText)).or()).like(StrUtil.isNotBlank((CharSequence)searchText), SysDocStandardLibEntity::getWjmc, (Object)searchText));
        }
        IPage libEntityIpage = sysDocStandardLibEntityLambdaQueryChainWrapper.page((IPage)libResIpage);
        List objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
            BeanUtils.copyProperties((Object)e, (Object)((Object)sysDocStandardLibRes));
            String qcr = e.getQcr();
            sysDocStandardLibRes.setQcr((BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class));
            String bzdw = e.getBzdw();
            sysDocStandardLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
            String bzbm = e.getBzbm();
            sysDocStandardLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
            String syfw = e.getSyfw();
            sysDocStandardLibRes.setSyfw(JSONObject.parseArray((String)syfw, String.class));
            if (StringUtils.isNotEmpty((CharSequence)syfw)) {
                sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNamesByCodes(syfw));
            }
            String syxmlb = e.getSyxmlb();
            sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray((String)syxmlb, String.class));
            if (StringUtils.isNotEmpty((CharSequence)syxmlb)) {
                sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
            }
            String gltx1 = e.getGltx();
            sysDocStandardLibRes.setGltx(JSONObject.parseArray((String)gltx1, String.class));
            if (StringUtils.isNotEmpty((CharSequence)gltx1)) {
                sysDocStandardLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx1));
            }
            sysDocStandardLibRes.setBzdw1(e.getBzdw());
            sysDocStandardLibRes.setBzbm1(e.getBzbm());
            sysDocStandardLibRes.setQcr1(e.getQcr());
            objects.add(sysDocStandardLibRes);
        });
        Page page = new Page(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param) {
        Map params = param.getParams();
        Parameter gltxParameter = params.getOrDefault("gltx", null);
        String gltx = Objects.isNull(gltxParameter) ? "" : String.valueOf(gltxParameter.getValue());
        Parameter type = params.getOrDefault("type", null);
        String searchText = param.getSearchText();
        Page libResIpage = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        LambdaQueryChainWrapper sysDocInstitutionalLibEntityLambdaQueryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().eq(Objects.nonNull(type), SysDocInstitutionalLibEntity::getType, (Object)String.valueOf(type.getValue()))).like(StringUtils.isNotBlank((CharSequence)gltx), SysDocInstitutionalLibEntity::getGltx, (Object)gltx)).orderByDesc(BaseEntity::getCreateTime);
        if (StrUtil.isNotBlank((CharSequence)searchText)) {
            sysDocInstitutionalLibEntityLambdaQueryChainWrapper.and(i -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(StrUtil.isNotBlank((CharSequence)searchText), SysDocInstitutionalLibEntity::getZdbt, (Object)searchText)).or()).like(StrUtil.isNotBlank((CharSequence)searchText), SysDocInstitutionalLibEntity::getZdbm, (Object)searchText));
        }
        IPage libEntityIpage = sysDocInstitutionalLibEntityLambdaQueryChainWrapper.page((IPage)libResIpage);
        List objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            String bzbm;
            SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
            BeanUtils.copyProperties((Object)e, (Object)((Object)docInstitutionalLibRes));
            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty((CharSequence)bzdw)) {
                docInstitutionalLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzbm = e.getBzbm()))) {
                docInstitutionalLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
            }
            String gltx1 = e.getGltx();
            docInstitutionalLibRes.setGltx(JSONObject.parseArray((String)gltx1, String.class));
            if (StringUtils.isNotEmpty((CharSequence)gltx1)) {
                docInstitutionalLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx1));
            }
            objects.add(docInstitutionalLibRes);
        });
        Page page = new Page(libEntityIpage.getCurrent(), libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public SysDocStandardLibRes standardDetail(Long id) {
        SysDocStandardLibEntity sysDocStandardLibEntity = (SysDocStandardLibEntity)((Object)this.standardLibraryDao.getById(id));
        SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
        BeanUtils.copyProperties((Object)((Object)sysDocStandardLibEntity), (Object)((Object)sysDocStandardLibRes));
        String qcr = sysDocStandardLibEntity.getQcr();
        String origin = sysDocStandardLibEntity.getOrigin();
        sysDocStandardLibRes.setQcr((BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class));
        sysDocStandardLibRes.setQcr1(sysDocStandardLibEntity.getQcr());
        String bzdw = sysDocStandardLibEntity.getBzdw();
        sysDocStandardLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
        sysDocStandardLibRes.setBzdw1(sysDocStandardLibEntity.getBzdw());
        String bzbm = sysDocStandardLibEntity.getBzbm();
        sysDocStandardLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
        sysDocStandardLibRes.setBzbm1(sysDocStandardLibEntity.getBzbm());
        String syfw = sysDocStandardLibEntity.getSyfw();
        if (StringUtils.isNotEmpty((CharSequence)syfw)) {
            sysDocStandardLibRes.setSyfw(JSONObject.parseArray((String)syfw, String.class));
            sysDocStandardLibRes.setSyfw1(ApplicableScopeEnum.getNamesByCodes(syfw));
        } else {
            sysDocStandardLibRes.setSyfw(Lists.newArrayList());
            sysDocStandardLibRes.setSyfw1("");
        }
        String syxmlb = sysDocStandardLibEntity.getSyxmlb();
        if (StringUtils.isNotEmpty((CharSequence)syxmlb)) {
            sysDocStandardLibRes.setSyxmlb(JSONObject.parseArray((String)syxmlb, String.class));
            sysDocStandardLibRes.setSyxmlb1(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
        } else {
            sysDocStandardLibRes.setSyxmlb(Lists.newArrayList());
            sysDocStandardLibRes.setSyxmlb1("");
        }
        String gltx = sysDocStandardLibEntity.getGltx();
        if (StringUtils.isNotEmpty((CharSequence)gltx)) {
            sysDocStandardLibRes.setGltx(JSONObject.parseArray((String)gltx, String.class));
            sysDocStandardLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx));
        } else {
            sysDocStandardLibRes.setGltx(Lists.newArrayList());
            sysDocStandardLibRes.setGltx1("");
        }
        if ("OA".equals(origin)) {
            String docFileUrl = this.getDocFileUrl(sysDocStandardLibEntity.getWjnr());
            sysDocStandardLibRes.setWjnr(docFileUrl);
        }
        return sysDocStandardLibRes;
    }

    @Override
    public SysDocInstitutionalLibRes institutionalDetail(Long id) {
        String gltx;
        String bzbm;
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = (SysDocInstitutionalLibEntity)((Object)this.institutionalLibraryDao.getById(id));
        SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
        BeanUtils.copyProperties((Object)((Object)sysDocInstitutionalLibEntity), (Object)((Object)docInstitutionalLibRes));
        String bzdw = sysDocInstitutionalLibEntity.getBzdw();
        if (StringUtils.isNotEmpty((CharSequence)bzdw)) {
            docInstitutionalLibRes.setBzdw((BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bzbm = sysDocInstitutionalLibEntity.getBzbm()))) {
            docInstitutionalLibRes.setBzbm((BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(gltx = sysDocInstitutionalLibEntity.getGltx()))) {
            docInstitutionalLibRes.setGltx(JSONObject.parseArray((String)gltx, String.class));
            docInstitutionalLibRes.setGltx1(ManagementSystemEnum.getNamesByCodes(gltx));
        } else {
            docInstitutionalLibRes.setGltx(Lists.newArrayList());
            docInstitutionalLibRes.setGltx1("");
        }
        if ("OA".equals(sysDocInstitutionalLibEntity.getOrigin())) {
            String docFileUrl = this.getDocFileUrl(sysDocInstitutionalLibEntity.getZdzw());
            docInstitutionalLibRes.setZdzw(docFileUrl);
        }
        return docInstitutionalLibRes;
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("\u6587\u4ef6\u5e93\u7c7b\u578b\u4e0d\u5b58\u5728:\u3010\u6807\u51c6\u5e93STANDARD/\u5236\u5ea6\u5e93INSTITUTIONAL\u3011");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                this.institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                this.standardLibraryDao.removeByIds(vo.getIds());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f53\u7cfb\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String bzbm;
            String bzdw;
            String qcr;
            String syxmlb;
            String zt;
            String gltx;
            String syfw;
            String type = item.getType();
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                item.setType(QualityTypeEnum.getNameByCode(type));
            }
            if (StringUtils.isNotEmpty((CharSequence)(syfw = item.getSyfw()))) {
                item.setSyfw(ApplicableScopeEnum.getNamesByCodes(syfw));
            }
            if (StringUtils.isNotEmpty((CharSequence)(gltx = item.getGltx()))) {
                item.setGltx(ManagementSystemEnum.getNamesByCodes(gltx));
            }
            if (StringUtils.isNotEmpty((CharSequence)(zt = item.getZt()))) {
                item.setZt(SystemDocumentsStatusEnum.getNameByCode(zt));
            }
            if (StringUtils.isNotEmpty((CharSequence)(syxmlb = item.getSyxmlb()))) {
                item.setSyxmlb(ApplicableProjectCategoriesEnum.getNamesByCodes(syxmlb));
            }
            if (StringUtils.isNotEmpty((CharSequence)(qcr = item.getQcr()))) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)qcr, BaseInfoVo.class);
                item.setQcr(baseInfoVo.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzdw = item.getBzdw()))) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)bzdw, BaseInfoVo.class);
                item.setBzdw(baseInfoVo.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(bzbm = item.getBzbm()))) {
                BaseInfoVo baseInfoVo = (BaseInfoVo)JSONObject.parseObject((String)bzbm, BaseInfoVo.class);
                item.setBzbm(baseInfoVo.getName());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u6807\u51c6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = item.getGltx();
            if (StringUtils.isNotEmpty((CharSequence)gltx)) {
                item.setGltx(ManagementSystemEnum.getNamesByCodes(gltx));
            }
            item.setType(typeName);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setBzdw(((BaseInfoVo)JSONObject.parseObject((String)item.getBzdw(), BaseInfoVo.class)).getName());
            item.setBzbm(((BaseInfoVo)JSONObject.parseObject((String)item.getBzbm(), BaseInfoVo.class)).getName());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5236\u5ea6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void oaStandardScheduled() {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity<String> requestEntity = this.getRequestEntity(STANDARD_API_TOKEN);
        ResponseEntity exchange = restTemplate.exchange(STANDARD_OA_URL, HttpMethod.POST, requestEntity, OaStandardRes.class, new Object[0]);
        OaStandardRes body = (OaStandardRes)exchange.getBody();
        if (Objects.isNull(body) || !body.getSuccess().booleanValue()) {
            throw new BusinessException("\u6807\u51c6\u5f15\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + (body != null ? body.getErrorInfo() : "\u6807\u51c6\u5f15\u5165\u5931\u8d25"));
        }
        List<OaStandardRes.DataDTO> data = body.getData();
        ArrayList<SysDocStandardLibEntity> entities = new ArrayList<SysDocStandardLibEntity>();
        if (CollUtil.isEmpty(data)) {
            return;
        }
        List oaList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).eq(SysDocStandardLibEntity::getOrigin, (Object)"OA")).list();
        Map<String, Map<String, SysDocStandardLibEntity>> wjnrUpdateTimeMap = oaList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SysDocStandardLibEntity::getWjnr, Collectors.toMap(e -> DateUtil.format((Date)e.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), Function.identity())));
        List collect = data.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getGzgltx())).collect(Collectors.toList());
        for (OaStandardRes.DataDTO dto : collect) {
            this.processDataDTO(dto, wjnrUpdateTimeMap, entities);
        }
        if (CollUtil.isNotEmpty(entities)) {
            HashSet<Long> existingIds = new HashSet<Long>();
            List collect1 = oaList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            for (SysDocStandardLibEntity entity : entities.stream().filter(e -> Objects.isNull(e.getId())).collect(Collectors.toSet())) {
                long newId;
                while (!existingIds.add(newId = this.generateUniqueId()) || collect1.contains(newId)) {
                }
                entity.setId(newId);
            }
            this.standardLibraryDao.saveOrUpdateBatch(entities);
        }
    }

    private void processDataDTO(OaStandardRes.DataDTO dto, Map<String, Map<String, SysDocStandardLibEntity>> wjnrUpdateTimeMap, List<SysDocStandardLibEntity> entities) {
        String wjnr = dto.getQybzfj();
        String modedatamodifydatetime = dto.getModedatamodifydatetime();
        if (wjnrUpdateTimeMap.containsKey(wjnr)) {
            Map<String, SysDocStandardLibEntity> dateSysDocStandardLibEntityMap = wjnrUpdateTimeMap.get(wjnr);
            if (dateSysDocStandardLibEntityMap.containsKey(modedatamodifydatetime)) {
                return;
            }
            dateSysDocStandardLibEntityMap.values().forEach(sysDocStandardLibEntity -> entities.add(this.createEntityFromDTO(dto, sysDocStandardLibEntity.getId())));
        } else {
            entities.add(this.createEntityFromDTO(dto, null));
        }
    }

    private SysDocStandardLibEntity createEntityFromDTO(OaStandardRes.DataDTO dto, Long existingId) {
        SysDocStandardLibEntity entity = new SysDocStandardLibEntity();
        if (existingId != null) {
            entity.setId(existingId);
        }
        String defaultJsonStr = this.createEntity(dto, entity);
        entity.setSyxmlb(this.getEnumValue(dto.getSyxmlb2(), ApplicableProjectCategoriesEnum::conversionApiData));
        entity.setSyfw(this.getEnumValue(dto.getSyfw2(), ApplicableScopeEnum::conversionApiData));
        entity.setZt(Objects.nonNull(dto.getZt()) ? SystemDocumentsStatusEnum.getCodeByApiCode(dto.getZt()) : null);
        entity.setBz(Objects.nonNull(dto.getBz()) ? String.valueOf(dto.getBz()) : null);
        entity.setFbrq(StrUtil.isNotBlank((CharSequence)dto.getFbrq()) ? DateUtil.parse((String)dto.getFbrq(), (String)"yyyy-MM-dd").toSqlDate() : null);
        entity.setSsrq(StrUtil.isNotBlank((CharSequence)dto.getSsrq()) ? DateUtil.parse((String)dto.getSsrq(), (String)"yyyy-MM-dd").toSqlDate() : null);
        entity.setBzbm(defaultJsonStr);
        entity.setBzdw(defaultJsonStr);
        entity.setBm(dto.getWdbh());
        entity.setFssj(StrUtil.isNotBlank((CharSequence)dto.getFssjs()) ? DateUtil.parse((String)dto.getFssjs(), (String)"yyyy-MM-dd").toSqlDate() : null);
        entity.setTdxx(dto.getTdxx());
        entity.setGkdw("OA\u63a8\u9001");
        entity.setBb(Objects.nonNull(dto.getBb()) ? String.valueOf(dto.getBb()) : null);
        entity.setQcr(defaultJsonStr);
        entity.setGltx(JSONObject.toJSONString(this.getGltx(dto.getGzgltx())));
        return entity;
    }

    private String createEntity(OaStandardRes.DataDTO dto, SysDocStandardLibEntity entity) {
        BaseInfoVo baseInfoVo = new BaseInfoVo();
        baseInfoVo.setId("OA\u63a8\u9001");
        baseInfoVo.setCode("OA\u63a8\u9001");
        baseInfoVo.setName("OA\u63a8\u9001");
        String defaultJsonStr = JSONUtil.toJsonStr((Object)baseInfoVo);
        entity.setCreateUserCode("OA\u63a8\u9001");
        entity.setCreateTime((Date)DateUtil.parseDateTime((String)StrUtil.join((CharSequence)" ", (Object[])new Object[]{dto.getModedatacreatedate(), dto.getModedatacreatetime()})));
        entity.setUpdateTime((Date)DateUtil.parseDateTime((String)dto.getModedatamodifydatetime()));
        entity.setCreateUserName("OA\u63a8\u9001");
        entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
        entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
        entity.setWjbh(dto.getWdbh());
        entity.setWjmc(dto.getWdmc());
        entity.setWjnr(dto.getQybzfj());
        return defaultJsonStr;
    }

    private List<String> getGltx(String gltx) {
        ArrayList<String> res = new ArrayList<String>(Collections.emptyList());
        if (StringUtils.isNotBlank((CharSequence)gltx)) {
            String[] split;
            for (String s : split = gltx.split(",")) {
                String scopeCodeByApiCode = ManagementSystemEnum.getCodeByApiCode(s);
                res.add(scopeCodeByApiCode);
            }
        }
        return res;
    }

    private <T> T getEnumValue(String value, Function<String, T> converter) {
        return StringUtils.isNotBlank((CharSequence)value) ? (T)converter.apply(value) : null;
    }

    @Override
    public void oaInstitutionalScheduled() {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity<String> requestEntity = this.getRequestEntity(INSTITUTIONAL_API_TOKEN);
        ResponseEntity exchange = restTemplate.exchange(INSTITUTIONAL_OA_URL, HttpMethod.POST, requestEntity, OaInstitutionalRes.class, new Object[0]);
        OaInstitutionalRes body = (OaInstitutionalRes)exchange.getBody();
        if (Objects.isNull(body) || !body.getSuccess().booleanValue()) {
            throw new BusinessException("\u5236\u5ea6\u5e93\u5f15\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + (body != null ? body.getErrorInfo() : "\u5236\u5ea6\u5e93\u5f15\u5165\u5931\u8d25"));
        }
        List<OaInstitutionalRes.DataDTO> data = body.getData();
        ArrayList<SysDocInstitutionalLibEntity> entities = new ArrayList<SysDocInstitutionalLibEntity>();
        if (CollUtil.isEmpty(data)) {
            return;
        }
        List oaList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).eq(SysDocInstitutionalLibEntity::getOrigin, (Object)"OA")).list();
        Map wjnrUpdateTimeMap = oaList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SysDocInstitutionalLibEntity::getZdzw, Collectors.toMap(e -> DateUtil.format((Date)e.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), Function.identity())));
        for (OaInstitutionalRes.DataDTO dto : data) {
            if (dto == null) continue;
            String zdzw = String.valueOf(dto.getZdpdfzw());
            String modedatamodifydatetime = dto.getModedatamodifydatetime();
            SysDocInstitutionalLibEntity entity = this.createEntityFromDto(dto, zdzw, modedatamodifydatetime);
            if (wjnrUpdateTimeMap.containsKey(zdzw) && wjnrUpdateTimeMap.get(zdzw).containsKey(modedatamodifydatetime)) continue;
            if (wjnrUpdateTimeMap.containsKey(zdzw)) {
                Long id = ((SysDocInstitutionalLibEntity)((Object)wjnrUpdateTimeMap.get(zdzw).get(modedatamodifydatetime))).getId();
                entity.setId(id);
            }
            entities.add(entity);
        }
        if (CollUtil.isNotEmpty(entities)) {
            HashSet<Long> existingIds = new HashSet<Long>();
            List collect1 = oaList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            for (SysDocInstitutionalLibEntity entity : entities) {
                long newId;
                if (!Objects.isNull(entity.getId())) continue;
                while (!existingIds.add(newId = this.generateUniqueId()) || collect1.contains(newId)) {
                }
                entity.setId(newId);
            }
            this.institutionalLibraryDao.saveOrUpdateBatch(entities);
        }
    }

    private SysDocInstitutionalLibEntity createEntityFromDto(OaInstitutionalRes.DataDTO dto, String zdzw, String modedatamodifydatetime) {
        BaseInfoVo baseInfoVo = new BaseInfoVo();
        baseInfoVo.setId("OA\u63a8\u9001");
        baseInfoVo.setCode("OA\u63a8\u9001");
        baseInfoVo.setName("OA\u63a8\u9001");
        String defaultJsonStr = JSONUtil.toJsonStr((Object)baseInfoVo);
        SysDocInstitutionalLibEntity entity = new SysDocInstitutionalLibEntity();
        entity.setCreateUserCode("OA\u63a8\u9001");
        entity.setCreateTime((Date)DateUtil.parseDateTime((String)StrUtil.join((CharSequence)" ", (Object[])new Object[]{dto.getModedatacreatedate(), dto.getModedatacreatetime()})));
        entity.setUpdateTime((Date)DateUtil.parseDateTime((String)modedatamodifydatetime));
        entity.setCreateUserName("OA\u63a8\u9001");
        entity.setType(QualityTypeEnum.HEADQUARTERS.getTypeCode());
        entity.setOrigin(SystemDocumentsOriginEnum.OA.getOriginCode());
        entity.setBzbm(defaultJsonStr);
        entity.setBzdw(defaultJsonStr);
        entity.setZdbt(dto.getZdbt());
        entity.setZdzw(zdzw);
        entity.setZdbb(Objects.nonNull(dto.getZdbb()) ? String.valueOf(dto.getZdbb()) : null);
        entity.setFwh(dto.getFwh());
        entity.setZdbm(dto.getZdbh());
        String fbrq = dto.getFbrq();
        entity.setFbrq(Objects.nonNull(fbrq) ? DateUtil.parse((String)fbrq, (String)"yyyy-MM-dd").toSqlDate() : null);
        entity.setSyjg(dto.getSyjg());
        entity.setSpjg(dto.getSpjg());
        entity.setBm(Objects.nonNull(dto.getBm()) ? String.valueOf(dto.getBm()) : null);
        return entity;
    }

    private long generateUniqueId() {
        return UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
    }

    private HttpEntity<String> getRequestEntity(String apiToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("API-TOKEN", apiToken);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("pageNo", 1);
        map.put("pageSize", 99999);
        String jsonBody = JSONObject.toJSONString(map);
        return new HttpEntity((Object)jsonBody, (MultiValueMap)headers);
    }

    private String getDocFileUrl(String fileId) {
        String oaToken = this.getOaToken();
        return "https://oa.ztpc.com/spa/document/index.jsp?id=" + fileId + "&router=1&ssoToken=" + oaToken + "#/main/document/detail";
    }

    private String getOaToken() {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"appid", (Object)"b5db6599-3bb1-43b2-a2c2-d4eaf8f93d26");
        body.add((Object)"loginid", (Object)"816050");
        ResponseEntity exchange = restTemplate.exchange(OA_TOKEN, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
        return (String)exchange.getBody();
    }

    public SystemDocumentsServerImpl(InstitutionalLibraryDao institutionalLibraryDao, StandardLibraryDao standardLibraryDao, SessionManager sessionManager) {
        this.institutionalLibraryDao = institutionalLibraryDao;
        this.standardLibraryDao = standardLibraryDao;
        this.sessionManager = sessionManager;
    }
}

