package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 管理体系(内部控制 、 质量 、 职业健康安全 、 环境管理 、 测量 、 特种设备 、 ASME 、 标准 、 核电工程 、 核电制造)
 */
@Getter
@AllArgsConstructor
public enum ManagementSystemEnum {
    /**
     * 特种设备管理体系
     */
    TZSB("TZSB", "特种设备管理体系", "0"),
    /**
     * 内部控制管理体系
     */
    NBKZ("NBKZ", "内部控制管理体系", "10"),
    /**
     * 质量管理体系
     */
    ZL("ZL", "质量管理体系", "1"),
    /**
     * 职业健康安全管理体系
     */
    ZYJKAQ("ZYJKAQ", "职业健康安全管理体系", "2"),
    /**
     * 环境管理管理体系
     */
    HJ("HJ", "环境管理管理体系", "3"),
    /**
     * 测量管理体系
     */
    CL("CL", "测量管理体系", "8"),
    /**
     * ASME管理体系
     */
    ASME("ASME", "ASME管理体系", "7"),
    /**
     * 标准管理体系
     */
    BZ("BZ", "标准管理体系", "6"),
    /**
     * 核电工程管理体系
     */
    HDGC("HDGC", "核电工程管理体系", "4"),
    /**
     * 核电制造管理体系
     */
    HDZZ("HDZZ", "核电制造管理体系", "5"),
    ;

    private final String managementCode;

    private final String managementName;

    private final String apiCode;

    public static final ManagementSystemEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static final List<String> CODELIST = Arrays.stream(VALUES).map(ManagementSystemEnum::getManagementCode).collect(Collectors.toList());


    public static String getNamesByCodes(String scopeCode) {
        JSONArray objects = JSONUtil.parseArray(scopeCode, true);
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object object : objects) {
            for (ManagementSystemEnum managementSystemEnum : values()) {
                if (managementSystemEnum.getManagementCode().equals(object)) {
                    stringJoiner.add(managementSystemEnum.getManagementName());
                }
            }
        }
        return stringJoiner.toString();
    }

    public static String getNameByCode(String managementCode) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getManagementCode().equals(managementCode)) {
                return managementSystemEnum.getManagementName();
            }
        }
        return "未知";
    }

    public static String getCodeByName(String managementName) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getManagementName().equals(managementName)) {
                return managementSystemEnum.getManagementCode();
            }
        }
        return "errorCode";
    }

    public static String getCodeByApiCode(String apiCode) {
        for (ManagementSystemEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getApiCode().equals(apiCode)) {
                return managementSystemEnum.getManagementCode();
            }
        }
        return "errorCode";
    }
}
