package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午11:03
 * @Description: 管理评审-改进建议
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewRefineAdviceVo extends BaseVO {

    /**
     * 改进建议-改进建议
     */
    private String refineAdvice;

    /**
     * 内容
     */
    private String content;

    /**
     * 改进建议-改进建议文件名称
     */
    private String refineAdviceAttachmentName;

    /**
     * 改进建议-改进建议文件
     */
    private String refineAdviceAttachment;

    /**
     * 改进建议-上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传部门
     */
    private String uploadDept;


    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;

    /**
     * 单据编号
     */
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    private Integer billState;
}
