package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/20 上午10:02
 * @Description: 经验反馈下达详情
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_issued_detail")
public class ExperienceFeedbackIssuedDetailEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 创建者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 经验反馈下达id
     */
    @TableField(value = "issued_id")
    private Long issuedId;

    /**
     * 下达时间
     */
    @TableField(value = "release_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 归属类型
     */
    @TableField(value = "attribution_type")
    private String attributionType;

    /**
     * 专业
     */
    @TableField(value = "specialized")
    private String specialized;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 学习附件名称
     */
    @TableField(value = "study_annex_name")
    private String studyAnnexName;

    /**
     * 学习附件
     */
    @TableField(value = "study_annex")
    private String studyAnnex;

    /**
     * 附件名称
     */
    @TableField(value = "annex_name")
    private String annexName;

    /**
     * 附件
     */
    @TableField(value = "annex")
    private String annex;

    /**
     * 上传部门id
     */
    @TableField(value = "upload_department_id")
    private Long uploadDepartmentId;

    /**
     * 上传部门name
     */
    @TableField(value = "upload_department_name")
    private String uploadDepartmentName;

    /**
     * 负责人
     */
    @TableField(value = "charge")
    private String charge;

    /**
     * 负责人
     */
    @TableField(value = "charge_name")
    private String chargeName;

    /**
     * 领导
     */
    @TableField(value = "leader")
    private String leader;
    @TableField(value = "leader_name")
    private String leaderName;


    /**
     * 上传时间
     */
    @TableField(value = "upload_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 上报状态（已上报 未上报）
     */
    @TableField(value = "state")
    private String state;

    /**
     * 学习情况(全部学习 部分学习 未学习)
     */
    @TableField(value = "learn_state")
    private String learnState;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
