package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackBankDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackBankEntity;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.business.quality.service.ExpFeedbackBankServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Date;
import java.util.Arrays;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/25 下午3:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ExpFeedbackBankServerImpl implements ExpFeedbackBankServer {
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final ExpFeedbackBankDao bankDao;
    private final SessionManager sessionManager;

    @Override
    public CommonResponse<List<ExpFeedbackBankVo>> enterBank(List<Long> ids) {
        List<ExperienceFeedbackIssuedDetailEntity> detailList = detailDao.lambdaQuery().in(BaseEntity::getId, ids).list();

        List<ExpFeedbackBankEntity> enterList = Lists.newArrayList();
        for (ExperienceFeedbackIssuedDetailEntity experienceFeedbackIssuedDetailEntity : detailList) {
            ExpFeedbackBankEntity expFeedbackBankEntity = enterBankEntity(experienceFeedbackIssuedDetailEntity);
            enterList.add(expFeedbackBankEntity);
        }
        bankDao.saveBatch(enterList);

        return CommonResponse.success("入库成功", BeanMapper.mapList(enterList, ExpFeedbackBankVo.class));
    }

    private ExpFeedbackBankEntity enterBankEntity(ExperienceFeedbackIssuedDetailEntity experienceFeedbackIssuedDetailEntity) {
        ExpFeedbackBankEntity expFeedbackBankEntity = new ExpFeedbackBankEntity();
        expFeedbackBankEntity.setCreateUserName(sessionManager.getUserContext().getUserName());
        expFeedbackBankEntity.setReleaseTime(experienceFeedbackIssuedDetailEntity.getReleaseTime());
        expFeedbackBankEntity.setAttributionType(experienceFeedbackIssuedDetailEntity.getAttributionType());
        expFeedbackBankEntity.setSpecialized(experienceFeedbackIssuedDetailEntity.getSpecialized());
        expFeedbackBankEntity.setTopic(experienceFeedbackIssuedDetailEntity.getTopic());
        expFeedbackBankEntity.setSubstance(experienceFeedbackIssuedDetailEntity.getSubstance());
        expFeedbackBankEntity.setDetailId(experienceFeedbackIssuedDetailEntity.getId());
        expFeedbackBankEntity.setAnnexName(experienceFeedbackIssuedDetailEntity.getAnnexName());
        expFeedbackBankEntity.setUploadDepartmentId(experienceFeedbackIssuedDetailEntity.getUploadDepartmentId());
        expFeedbackBankEntity.setUploadDepartmentName(experienceFeedbackIssuedDetailEntity.getUploadDepartmentName());
        expFeedbackBankEntity.setUploadTime(experienceFeedbackIssuedDetailEntity.getUploadTime());
        return expFeedbackBankEntity;
    }

    @Override
    public ExpFeedbackBankVo saveOrUpdate(ExpFeedbackBankVo saveOrUpdateVO) {
        ExpFeedbackBankEntity entity = BeanMapper.map(saveOrUpdateVO, ExpFeedbackBankEntity.class);
        Long id = entity.getId();
        UserContext userContext = sessionManager.getUserContext();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            entity.setUploadDepartmentId(userContext.getDeptId());
            entity.setUploadDepartmentName(userContext.getDeptName());
            entity.setUploadTime(new Date(System.currentTimeMillis()));
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
            entity.setState("未学习");

        }else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(detailDao.getById(id).getCreateUserName());
        }
        bankDao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ExpFeedbackBankVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            bankDao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedbackBankVo detail(Long id) {
        ExpFeedbackBankEntity expFeedbackBankEntity = bankDao.selectById(id);
        return BeanMapper.map(expFeedbackBankEntity, ExpFeedbackBankVo.class);
    }

    @Override
    public IPage<ExpFeedbackBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName"
                , "uploadDepartmentName", "learnUnitName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ExpFeedbackBankEntity> page = bankDao.queryPage(param, false);
        IPage<ExpFeedbackBankVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpFeedbackBankVo.class));

        return pageData;
    }
}
